package eu.dnetlib.data.mapreduce.hbase.propagation;

import eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories.InstOrgKey;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Partitioner;

/**
 * Created by miriam on 17/08/2018.
 */
public class NaturalKeyPartitioner extends Partitioner<InstOrgKey, ImmutableBytesWritable > {

    @Override
    public int getPartition(InstOrgKey key, ImmutableBytesWritable  val, int numPartitions) {
        final int res = Math.abs(key.getId().hashCode() % numPartitions);

        //System.out.println(String.format("%s goes to partition %s", key.toString(), res));

        return res;
    }
}
