/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import com.google.common.collect.Lists;
import eu.dnetlib.data.mapreduce.hbase.index.EmptySolrDocumentException;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.functionality.index.solr.feed.StreamingInputDocumentFactory;
import eu.dnetlib.miscutils.datetime.HumanTime;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;

public class IndexLocalMapper
extends Mapper<Text, Text, Text, Text> {
    private static final Log log = LogFactory.getLog(IndexLocalMapper.class);
    public static final String DNET_RESULT = "dnetResult";
    private InputDocumentFactory documentFactory;
    private CloudSolrClient solrClient;
    private String version;
    private String dsId;
    private int shutdownWaitTime = 10000;
    private int bufferFlushThreshold = 100;
    private ApplyXslt dmfToRecord;
    private List<SolrInputDocument> buffer;
    private int backoffTimeMs = 5000;
    private boolean simulation = false;
    private static final int MAX_INIT_RETRIES = 10;
    private static final int MAX_FEED_RETRIES = 10;
    private boolean compress = false;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.logConfiguration(context.getConfiguration());
        this.dsId = context.getConfiguration().get("id");
        this.shutdownWaitTime = Integer.parseInt(context.getConfiguration().get("index.shutdown.wait.time"));
        this.bufferFlushThreshold = Integer.parseInt(context.getConfiguration().get("index.buffer.flush.threshold"));
        this.documentFactory = new StreamingInputDocumentFactory();
        this.version = InputDocumentFactory.getParsedDateField((String)context.getConfiguration().get("index.feed.timestamp"));
        this.buffer = Lists.newArrayList();
        this.simulation = Boolean.parseBoolean(context.getConfiguration().get("index.solr.sim.mode"));
        this.compress = context.getConfiguration().getBoolean("index.solr.compress.result", false);
        String xslt = new String(Base64.decodeBase64((String)context.getConfiguration().get("index.xslt")));
        log.info((Object)("got xslt: \n" + xslt));
        log.info((Object)("got version: " + this.version));
        log.info((Object)("simulation: " + this.simulation));
        log.info((Object)("buffer size: " + this.bufferFlushThreshold));
        this.dmfToRecord = new ApplyXslt(xslt);
        String baseURL = context.getConfiguration().get("index.solr.url");
        log.info((Object)("solr server baseURL: " + baseURL));
        String collection = context.getConfiguration().get("index.solr.collection");
        log.info((Object)("solr server collection: " + collection));
        int count = 0;
        while (count <= 10) {
            try {
                ++count;
                log.info((Object)"initializing solr server...");
                this.solrClient = new CloudSolrClient.Builder().withZkHost(baseURL).build();
                this.solrClient.connect();
                this.solrClient.setParallelUpdates(true);
                this.solrClient.setDefaultCollection(collection);
                SolrPingResponse rsp = this.solrClient.ping();
                if (rsp.getStatus() != 0) {
                    throw new SolrServerException("bad init status: " + rsp.getStatus());
                }
                break;
            }
            catch (Throwable e) {
                if (this.solrClient != null) {
                    this.solrClient.close();
                }
                context.getCounter("index init", e.getMessage()).increment(1L);
                log.error((Object)String.format("failed to init solr client wait %dms, error:\n%s", this.backoffTimeMs, ExceptionUtils.getStackTrace((Throwable)e)));
                Thread.sleep(this.backoffTimeMs);
            }
        }
        if (count >= 10) {
            throw new IOException("reached max retries trying to connect to solr server: 10");
        }
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String indexRecord = "";
        SolrInputDocument doc = null;
        try {
            indexRecord = this.dmfToRecord.evaluate((Object)value.toString());
            doc = this.documentFactory.parseDocument(this.version, indexRecord, this.dsId, DNET_RESULT);
            if (doc == null || doc.isEmpty()) {
                throw new EmptySolrDocumentException();
            }
        }
        catch (Throwable e) {
            context.getCounter("index feed", "skipped records").increment(1L);
            this.handleError(key, value, context, indexRecord, doc, e);
            return;
        }
        for (int count = 0; count <= 10; ++count) {
            try {
                this.addDocument(context, doc);
                return;
            }
            catch (Throwable e) {
                context.getCounter("index feed", "retries").increment(1L);
                this.handleError(key, value, context, indexRecord, doc, e);
                log.info((Object)String.format("failed to feed documents, waiting %dms", this.backoffTimeMs));
                Thread.sleep(this.backoffTimeMs);
                continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] zip(String s) {
        if (s == null) throw new IllegalArgumentException("Cannot zip null or empty string");
        if (s.length() == 0) {
            throw new IllegalArgumentException("Cannot zip null or empty string");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipOutputStream.write(s.getBytes(StandardCharsets.UTF_8));
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to zip content", e);
        }
    }

    private void addDocument(Mapper.Context context, SolrInputDocument doc) throws SolrServerException, IOException, EmptySolrDocumentException {
        this.buffer.add(doc);
        if (this.buffer.size() >= this.bufferFlushThreshold) {
            this.doAdd(this.buffer, context);
        }
    }

    private void doAdd(List<SolrInputDocument> buffer, Mapper.Context context) throws SolrServerException, IOException {
        if (!this.simulation) {
            long start = System.currentTimeMillis();
            UpdateResponse rsp = this.solrClient.add(buffer);
            long stop = System.currentTimeMillis() - start;
            log.info((Object)("feed time for " + buffer.size() + " records : " + HumanTime.exactly((long)stop) + "\n"));
            int status = rsp.getStatus();
            context.getCounter("index feed", "status code: " + status).increment((long)buffer.size());
            if (status != 0) {
                throw new SolrServerException("bad status: " + status);
            }
            for (SolrInputDocument doc : buffer) {
                context.getCounter("index entity", this.getEntityType(doc)).increment(1L);
            }
        }
        buffer.clear();
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        try {
            if (!this.buffer.isEmpty()) {
                this.doAdd(this.buffer, context);
            }
            log.info((Object)("\nwaiting " + this.shutdownWaitTime + "ms before shutdown"));
            Thread.sleep(this.shutdownWaitTime);
            this.solrClient.close();
        }
        catch (SolrServerException e) {
            log.error((Object)("couldn't shutdown server " + e.getMessage()));
        }
    }

    private void handleError(Text key, Text value, Mapper.Context context, String indexRecord, SolrInputDocument doc, Throwable e) throws IOException, InterruptedException {
        context.getCounter("index feed", e.getClass().getName()).increment(1L);
        context.write((Object)key, (Object)this.printRottenRecord(context.getTaskAttemptID().toString(), value, indexRecord, doc, e));
    }

    private Text printRottenRecord(String taskid, Text value, String indexRecord, SolrInputDocument doc, Throwable e) {
        return new Text("\n**********************************\ntask: " + taskid + "\n" + this.check("original", value.toString() + this.check("indexRecord", indexRecord) + this.check("solrDoc", doc)) + this.check("error", e));
    }

    private String check(String label, Object value) {
        if (value != null && !value.toString().isEmpty()) {
            return "\n " + label + ":\n" + value + "\n";
        }
        return "\n";
    }

    private void logConfiguration(Configuration conf) {
        log.info((Object)"job configutation #################");
        for (Map.Entry e : conf) {
            log.info((Object)("'" + (String)e.getKey() + "' : '" + (String)e.getValue() + "'"));
        }
        log.info((Object)"end of job configutation #################\n\n");
    }

    private String getEntityType(SolrInputDocument doc) {
        if (!doc.containsKey((Object)"oaftype")) {
            return "unknown";
        }
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)doc.getFieldValue("oaftype").toString());
        switch (type) {
            case result: {
                if (!doc.containsKey((Object)"resulttypeid")) {
                    return "result";
                }
                return doc.getFieldValue("resulttypeid").toString();
            }
        }
        return type.toString();
    }
}

