package eu.dnetlib.data.mapreduce.hbase.broker;

import java.io.IOException;
import java.util.List;

import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventWrapper;
import eu.dnetlib.data.proto.FieldTypeProtos.StringField;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.ResultProtos.Result.Metadata;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;

import static eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory.asEvent;

/**
 * Created by claudio on 26/07/16.
 */
public class PublicationDateEventFactory {

	public static List<EventWrapper> process(final Oaf current, final Oaf other, final float trust)
			throws IOException, InterruptedException, DocumentException {
		return new PublicationDateEventFactory().processPublicationDate(current, other, trust);
	}

	private List<EventWrapper> processPublicationDate(final Oaf current, final Oaf other, final float trust)
			throws IOException, InterruptedException, DocumentException {
		final List<EventWrapper> events = Lists.newArrayList();
		if (hasPubDate(other)) {
			// doProcessPublicationDate(context, current, other, Topic.MORE_PUBLICATION_DATE);

			if (!hasPubDate(current)) {
				events.add(doProcessPublicationDate(current, other, Topic.ENRICH_MISSING_PUBLICATION_DATE, trust));
			}
		}
		return events;
	}

	private EventWrapper doProcessPublicationDate(final Oaf current, final Oaf other, final Topic topic, final float trust)
			throws IOException, InterruptedException, DocumentException {
		final Oaf.Builder prototype = Oaf.newBuilder(current);

		final StringField date = other.getEntity().getResult().getMetadata().getDateofacceptance();
		prototype.getEntityBuilder().getResultBuilder().getMetadataBuilder().setDateofacceptance(date);

		final Oaf oaf = prototype.build();

		final OpenAireEventPayload payload =
				HighlightFactory.highlightEnrichPublicationDate(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), date);

		return EventWrapper.newInstance(
				asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust),
				topic.getValue());
	}

	private boolean hasPubDate(final Oaf current) {
		final Metadata m = current.getEntity().getResult().getMetadata();
		return StringUtils.isNotBlank(m.getDateofacceptance().getValue());
	}

}
