package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import com.google.common.collect.Iterables;
import eu.dnetlib.broker.objects.Instance;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.broker.objects.Provenance;
import eu.dnetlib.broker.objects.Publication;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ResultProtos.Result;

import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.*;

/**
 * Created by claudio on 11/07/16.
 */
public class OpenAireEventPayloadFactory extends ProtoMapping {

	public static OpenAireEventPayload fromOAF(final OafEntity oaf,
			final OafEntity source,
			final float trust) {

		return fromOAF(oaf, trust, new Provenance()
				.setRepositoryName(getValue(source.getCollectedfromList()))
				.setUrl(Iterables.getFirst(mapInstances(oaf.getResult().getInstanceList()), new Instance()).getUrl())
				.setId(getValue(source.getOriginalIdList())));
	}

	public static OpenAireEventPayload fromOAF(final OafEntity oaf,
			final float trust, final Provenance provenance) {

		final Result.Metadata m = oaf.getResult().getMetadata();
		final Publication p = new Publication()
				.setOriginalId(getValue(oaf.getOriginalIdList()))
				.setTitles(listValues(m.getTitleList()))
				.setAbstracts(listValues(m.getDescriptionList()))
				.setLanguage(getKey(m.getLanguage()))
				.setSubjects(listValues(m.getSubjectList()))
				.setCreators(listValues(oaf.getResult().getMetadata().getAuthorList()))
				.setPublicationdate(getValue(m.getDateofacceptance()))
				.setPublisher(getValue(m.getPublisher()))
				.setEmbargoenddate(getValue(m.getEmbargoenddate()))
				.setContributor(listValues(m.getContributorList()))
				.setJournal(mapJournal(m.getJournal()))
				.setCollectedFrom(listValues(oaf.getCollectedfromList()))
				.setPids(mapPids(oaf.getPidList()))
				.setInstances(mapInstances(oaf.getResult().getInstanceList()))
				.setExternalReferences(mapExternalRefs(oaf.getResult().getExternalReferenceList()))
				.setProjects(mapRelatedProjects(oaf));

		return new OpenAireEventPayload()
				.setPublication(p)
				.setHighlight(new Publication())
				.setProvenance(provenance)
				.setTrust(trust);
	}

}
