package eu.dnetlib.data.mapreduce.hbase.broker.model;

import java.util.Date;
import java.util.stream.Collectors;

import org.apache.commons.codec.digest.DigestUtils;

public class EventWrapper {

	private EventMessage event;

	private String counterName;

	public static EventWrapper newInstance(final EventMessage event, final String counterName) {
		return new EventWrapper(event, counterName);
	}

	public EventWrapper(final EventMessage event, final String counterName) {
		this.event = event;
		this.counterName = counterName;
	}

	public Event asBrokerEvent() {

		final Date now = new Date();

		final Event event = new Event();
		event.setEventId("event-" + DigestUtils.md5Hex(getEvent().getTopic()).substring(0, 6) + "-" + calculatePayloadHash(getEvent().getPayload()));
		event.setProducerId(getEvent().getProducerId());
		event.setPayload(getEvent().getPayload());
		event.setMap(getEvent().getMap()
				.entrySet()
				.stream()
				.filter(e -> e.getValue().asObject() != null)
				.collect(Collectors.toMap(
						e -> e.getKey(),
						e -> e.getValue().asObject())));
		event.setTopic(getEvent().getTopic());
		event.setCreationDate(now);
		event.setExpiryDate(calculateExpiryDate(now, getEvent().getTthDays()));
		event.setInstantMessage(getEvent().getTthDays() == 0);
		return event;
	}

	private static String calculatePayloadHash(final String payload) {
		// TODO : the payload should be normalized before hashing it
		return DigestUtils.md5Hex(payload);
	}

	private static Date calculateExpiryDate(final Date now, final int ttlDays) {
		if (ttlDays < 0) {
			return null;
		} else if (ttlDays == 0) {
			return now;
		} else {
			return new Date(now.getTime() + (ttlDays * 24 * 60 * 60 * 1000));
		}
	}

	public EventMessage getEvent() {
		return event;
	}

	public String getCounterName() {
		return counterName;
	}
}
