package eu.dnetlib.data.mapreduce;

import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;

public class JobDriver {

	private static final Log log = LogFactory.getLog(JobDriver.class);

	public static void main(String[] args) throws Exception {

		final Configuration conf = new Configuration();

		final String path = args[0];

		Properties p = new Properties();
		p.load(new FileInputStream(path));

		log.info(String.format("loaded %s properties from %s", p.size(), path));

		for (final String name : p.stringPropertyNames()) {
			conf.set(name, p.getProperty(name));
		}

		Job job = Job.getInstance(conf, conf.get("job.name", "unknown"));

		System.exit(job.waitForCompletion(true) ? 0 : 1);
	}

}
