package eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import com.google.common.collect.ComparisonChain;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import static eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants.*;

/**
 * Created by miriam on 17/08/2018.
 */
public class InstOrgKey implements WritableComparable<InstOrgKey> {



    private IntWritable keyType;

    private Text id;

    public InstOrgKey() {}

    public static InstOrgKey create(final int keyType, final String id) {
        return new InstOrgKey(keyType, id);
    }

    public static InstOrgKey datasource(final String id) {
        return new InstOrgKey(DATASOURCE, id);
    }

    public static InstOrgKey organization(final String id) {
        return new InstOrgKey(ORGANIZATION, id);
    }

    public static InstOrgKey publication(final String id){
        return new InstOrgKey(PUBLICATION, id);
    }

    public InstOrgKey(final int keyType, final String id) {
        this.id = new Text(id);
        this.keyType = new IntWritable(keyType);
    }

    public void setKeyType(final IntWritable keyType) {
        this.keyType = keyType;
    }

    public void setId(final Text id) {
        this.id = id;
    }

    public Text getId() {
        return id;
    }

    public IntWritable getKeyType() {
        return keyType;
    }

    @Override
    public int compareTo(final InstOrgKey o) {
        final int res = ComparisonChain.start()
                .compare(getId(), o.getId())
                .compare(getKeyType(), o.getKeyType())
                .result();

        //System.out.println(String.format("%s.compareTo(%s) = %s", toString(), o.toString(), res));
        return res;
    }

    @Override
    public void write(final DataOutput out) throws IOException {
        keyType.write(out);
        id.write(out);
    }

    @Override
    public void readFields(final DataInput in) throws IOException {
        keyType = new IntWritable();
        keyType.readFields(in);
        id = new Text();
        id.readFields(in);
    }

    @Override
    public String toString() {
        return (new StringBuilder())
                .append('{')
                .append(getKeyType().get())
                .append(',')
                .append(getId())
                .append('}')
                .toString();
    }
}
