/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.mapreduce.hbase.broker.enrich.AbstractEnrichmentMapper;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class ProjectEnrichmentMapper
extends AbstractEnrichmentMapper {
    @Override
    protected String counterGroup() {
        return "Broker Enrichment projects";
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = this.getEntityType(key);
        byte[] body = value.getValue(Bytes.toBytes((String)type.toString()), Bytes.toBytes((String)"body"));
        if (body == null) {
            context.getCounter(this.counterGroup(), "missing metadata").increment(1L);
            return;
        }
        switch (type) {
            case project: {
                for (byte[] resultId : this.listRelatedIds(value, "resultProject_outcome_produces")) {
                    this.emit(context, resultId, body, "project");
                }
                break;
            }
            case result: {
                OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)OafDecoder.decode((byte[])body).getOaf());
                for (String relName : Arrays.asList("resultProject_outcome_isProducedBy")) {
                    for (OafProtos.Oaf rel : this.listRelations(value, relName)) {
                        oafBuilder.getEntityBuilder().addCachedOafRel(rel);
                        context.getCounter(this.counterGroup(), "rel: " + relName).increment(1L);
                    }
                }
                NavigableMap mergedIn = value.getFamilyMap(DedupUtils.getDedupCF_mergedInBytes(TypeProtos.Type.result));
                if (MapUtils.isEmpty((Map)mergedIn) & !DedupUtils.isRoot(key)) {
                    this.emit(context, key.copyBytes(), oafBuilder.build().toByteArray(), "result not deduped");
                    break;
                }
                if (DedupUtils.isRoot(key)) {
                    this.emit(context, key.copyBytes(), oafBuilder.build().toByteArray(), "result merges");
                    break;
                }
                this.emit(context, this.getRootId(mergedIn), oafBuilder.build().toByteArray(), "result mergedIn");
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type: " + type);
            }
        }
    }

    private Iterable<OafProtos.Oaf> listRelations(Result value, String relType) {
        NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)relType));
        if (MapUtils.isNotEmpty((Map)map)) {
            return Iterables.filter((Iterable)Iterables.transform(map.values(), (Function)new Function<byte[], OafProtos.Oaf>(){

                public OafProtos.Oaf apply(byte[] input) {
                    return OafDecoder.decode((byte[])input).getOaf();
                }
            }), (Predicate)new Predicate<OafProtos.Oaf>(){

                public boolean apply(OafProtos.Oaf rel) {
                    return !rel.getRel().getTarget().contains("unidentified");
                }
            });
        }
        return Lists.newArrayList();
    }

    private Iterable<byte[]> listRelatedIds(Result value, String relType) {
        NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)relType));
        if (MapUtils.isNotEmpty((Map)map)) {
            return map.keySet();
        }
        return Lists.newArrayList();
    }

    private TypeProtos.Type getEntityType(ImmutableBytesWritable key) {
        return OafRowKeyDecoder.decode((byte[])key.copyBytes()).getType();
    }

    private byte[] getRootId(Map<byte[], byte[]> mergedIn) {
        return (byte[])Iterables.getOnlyElement(mergedIn.keySet());
    }
}

