/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.model;

import eu.dnetlib.data.mapreduce.hbase.broker.model.Event;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.mapreduce.hbase.broker.model.MapValue;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

public class EventWrapper {
    private EventMessage event;
    private String counterName;

    public static EventWrapper newInstance(EventMessage event, String counterName) {
        return new EventWrapper(event, counterName);
    }

    public EventWrapper(EventMessage event, String counterName) {
        this.event = event;
        this.counterName = counterName;
    }

    public Event asBrokerEvent() {
        Date now = new Date();
        Event event = new Event();
        event.setEventId("event-" + DigestUtils.md5Hex((String)this.getEvent().getTopic()).substring(0, 6) + "-" + EventWrapper.calculatePayloadHash(this.getEvent().getPayload()));
        event.setProducerId(this.getEvent().getProducerId());
        event.setPayload(this.getEvent().getPayload());
        event.setMap(this.getEvent().getMap().entrySet().stream().filter(e -> ((MapValue)e.getValue()).asObject() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((MapValue)e.getValue()).asObject())));
        event.setTopic(this.getEvent().getTopic());
        event.setCreationDate(now);
        event.setExpiryDate(EventWrapper.calculateExpiryDate(now, this.getEvent().getTthDays()));
        event.setInstantMessage(this.getEvent().getTthDays() == 0);
        return event;
    }

    private static String calculatePayloadHash(String payload) {
        return DigestUtils.md5Hex((String)payload);
    }

    private static Date calculateExpiryDate(Date now, int ttlDays) {
        if (ttlDays < 0) {
            return null;
        }
        if (ttlDays == 0) {
            return now;
        }
        return new Date(now.getTime() + (long)(ttlDays * 24 * 60 * 60 * 1000));
    }

    public EventMessage getEvent() {
        return this.event;
    }

    public String getCounterName() {
        return this.counterName;
    }
}

