/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories.InstOrgKey;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.DatasourceProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.OrganizationProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class PropagationCountryFromDsOrgResultMapper
extends TableMapper<InstOrgKey, ImmutableBytesWritable> {
    private Value value = new Value();
    private ImmutableBytesWritable valueOut;
    private Set<String> datasourceTypes = Sets.newHashSet((Object[])new String[]{"pubsrepository::institutional"});
    private Set<String> whiteList = Sets.newHashSet((Object[])new String[]{"10|opendoar____::300891a62162b960cf02ce3827bb363c"});
    private Set<String> blackList = Sets.newHashSet((Object[])new String[]{""});

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.valueOut = new ImmutableBytesWritable();
        this.datasourceTypes.addAll(Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)context.getConfiguration().get("datasource.types", ""))));
        this.whiteList.addAll(Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)context.getConfiguration().get("datasource.whitelist", ""))));
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = OafRowKeyDecoder.decode((byte[])keyIn.copyBytes()).getType();
        OafProtos.OafEntity entity = this.getEntity(value, type);
        if (entity != null) {
            switch (type) {
                case datasource: {
                    DatasourceProtos.Datasource datasource = entity.getDatasource();
                    String id = entity.getId();
                    if (datasource == null) {
                        throw new RuntimeException("oaf type is datasource, but datasource proto is not found in oafproto");
                    }
                    String dsType = datasource.getMetadata().getDatasourcetype().getClassid();
                    if (this.datasourceTypes.contains(dsType)) {
                        if (this.blackList.contains(id)) {
                            context.getCounter("Propagation", "blacklisted ").increment(1L);
                            this.emitNotAllowedDatasource(context, entity.getId());
                            break;
                        }
                        this.emitAllowedDatasource(value, context, entity.getId(), dsType);
                        break;
                    }
                    if (this.whiteList.contains(id)) {
                        context.getCounter("Propagation", "whitelisted " + id).increment(1L);
                        this.emitAllowedDatasource(value, context, entity.getId(), dsType);
                        break;
                    }
                    this.emitNotAllowedDatasource(context, entity.getId());
                    break;
                }
                case organization: {
                    OrganizationProtos.Organization organization = entity.getOrganization();
                    if (organization == null) {
                        throw new RuntimeException("oaf type is organization, but organization proto is not found in oafproto");
                    }
                    FieldTypeProtos.Qualifier country = organization.getMetadata().getCountry();
                    if (country == null) {
                        context.getCounter("Propagation", "country elem does not exists").increment(1L);
                        break;
                    }
                    NavigableMap ds_org = value.getFamilyMap("datasourceOrganization_provision_isProvidedBy".getBytes());
                    if (!MapUtils.isNotEmpty((Map)ds_org)) break;
                    for (String dsId : ds_org.keySet().stream().map(String::new).collect(Collectors.toList())) {
                        this.value.getValue().set(country.getClassid().getBytes());
                        Gson gson = new Gson();
                        this.valueOut.set(gson.toJson((Object)this.value).getBytes());
                        context.write((Object)InstOrgKey.organization(dsId), (Object)this.valueOut);
                        context.getCounter("Propagation", "country ").increment(1L);
                    }
                    break;
                }
                case result: {
                    ResultProtos.Result result = entity.getResult();
                    for (ResultProtos.Result.Instance instance : result.getInstanceList()) {
                        String hostedBy = instance.getHostedby().getKey();
                        this.value.getValue().set(entity.getId().getBytes());
                        Gson gson = new Gson();
                        this.valueOut.set(gson.toJson((Object)this.value).getBytes());
                        context.write((Object)InstOrgKey.publication(hostedBy), (Object)this.valueOut);
                        context.getCounter("Propagation", "emit publication ").increment(1L);
                        String collectedFrom = instance.getCollectedfrom().getKey();
                        if (hostedBy.equals(collectedFrom)) continue;
                        context.write((Object)InstOrgKey.publication(collectedFrom), (Object)this.valueOut);
                        context.getCounter("Propagation", "emit publication ").increment(1L);
                    }
                    break;
                }
            }
        }
    }

    private void emitNotAllowedDatasource(Mapper.Context context, String id) throws IOException, InterruptedException {
        InstOrgKey datasource1 = InstOrgKey.datasource(id);
        context.getCounter("Propagation", "ds Type not in propagation allowed list").increment(1L);
        this.value.getValue().set("0".getBytes());
        Gson gson = new Gson();
        this.valueOut.set(gson.toJson((Object)this.value).getBytes());
        context.write((Object)datasource1, (Object)this.valueOut);
    }

    private void emitAllowedDatasource(Result value, Mapper.Context context, String id, String dsType) throws IOException, InterruptedException {
        InstOrgKey datasource1 = InstOrgKey.datasource(id);
        context.getCounter("Propagation", String.format("%s in propagation allowed list", dsType)).increment(1L);
        this.value.getValue().set("1".getBytes());
        this.value.setTrust(this.getTrust(value));
        Gson gson = new Gson();
        this.valueOut.set(gson.toJson((Object)this.value).getBytes());
        context.write((Object)datasource1, (Object)this.valueOut);
    }

    private OafProtos.OafEntity getEntity(Result value, TypeProtos.Type type) throws InvalidProtocolBufferException {
        NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)type.toString()));
        byte[] body = (byte[])map.get(Bytes.toBytes((String)"body"));
        if (body != null) {
            OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])body);
            if (oaf.getDataInfo().getDeletedbyinference()) {
                return null;
            }
            return oaf.getEntity();
        }
        return null;
    }

    private String getTrust(Result value) throws InvalidProtocolBufferException {
        NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)"datasource"));
        byte[] body = (byte[])map.get(Bytes.toBytes((String)"body"));
        if (body != null) {
            OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])body);
            return oaf.getDataInfo().getTrust();
        }
        return null;
    }
}

