/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories;

import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories.InstOrgKey;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Reducer;

public class PropagationCountryFromDsOrgResultReducer
extends TableReducer<InstOrgKey, ImmutableBytesWritable, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(PropagationCountryFromDsOrgResultReducer.class);
    static final String DNETCOUNTRYSCHEMA = "dnet:countries";
    private static final String DATA_INFO_TYPE = "propagation";
    private static final String SCHEMA_NAME = "dnet:provenanceActions";
    private static final String CLASS_ID = "propagation::country::instrepos";
    private static final String SCHEMA_ID = "dnet:provenanceActions";
    private ImmutableBytesWritable keyOut;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new ImmutableBytesWritable();
    }

    protected void reduce(InstOrgKey dsId, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Iterator<ImmutableBytesWritable> it = values.iterator();
        if (!it.hasNext()) {
            context.getCounter("Propagation", "empty information for key").increment(1L);
            return;
        }
        Gson gson = new Gson();
        Value v = (Value)gson.fromJson(Bytes.toString((byte[])it.next().get()), Value.class);
        String first = Bytes.toString((byte[])v.getValue().get());
        String trust = v.getTrust();
        if (!first.equals("0") && !first.equals("1")) {
            if (dsId.getKeyType().get() == TypeProtos.Type.organization.getNumber()) {
                throw new RuntimeException(String.format("First Element in reducer is not type of datasource, key: '%s', value: '%s' but the organization exists", dsId.toString(), first));
            }
            context.getCounter("Propagation", String.format("WARNINGS: First element value is  %s ", first));
            while (it.hasNext()) {
                byte[] targetRowKey = ((Value)gson.fromJson(Bytes.toString((byte[])it.next().get()), Value.class)).getValue().get();
                String resultId = Bytes.toString((byte[])targetRowKey);
                if (resultId.startsWith("50|")) continue;
                throw new RuntimeException("Wrong ordering. CHECK!!!");
            }
        }
        if (first.equals("1")) {
            context.getCounter("Propagation", "institutional datasource").increment(1L);
            if (!it.hasNext()) {
                context.getCounter("Propagation", "no information apart of type of datasource").increment(1L);
                return;
            }
            String country = Bytes.toString((byte[])((Value)gson.fromJson(Bytes.toString((byte[])it.next().get()), Value.class)).getValue().get());
            if (country.trim().length() != 2) {
                try {
                    Integer.parseInt(country.trim());
                }
                catch (Exception e) {
                    throw new RuntimeException("Second Element in reducer is not country " + country);
                }
                throw new RuntimeException("Second Element in reducer is not country " + country);
            }
            boolean propagate = true;
            while (it.hasNext()) {
                byte[] targetRowKey = ((Value)gson.fromJson(Bytes.toString((byte[])it.next().get()), Value.class)).getValue().get();
                String resultId = Bytes.toString((byte[])targetRowKey);
                if (!resultId.startsWith("50|")) {
                    if (resultId.equalsIgnoreCase(country)) continue;
                    context.getCounter("Propagation", String.format("resultId expected in ordering was not found. First country %s, second country %s", country, resultId)).increment(1L);
                    propagate = false;
                    continue;
                }
                if (!propagate) continue;
                byte[] oafUpdate = this.getOafCountry(resultId, country, trust);
                Put put = new Put(targetRowKey).add(Bytes.toBytes((String)"result"), Bytes.toBytes((String)("update_" + System.nanoTime())), oafUpdate);
                this.keyOut.set(targetRowKey);
                context.write((Object)this.keyOut, (Object)put);
                context.getCounter("Propagation", String.format(" added country %s to product from repo %s", country, StringUtils.substringBefore((String)resultId, (String)"::"))).increment(1L);
            }
        } else {
            context.getCounter("Propagation", "not allowed dsType institutional datasource").increment(1L);
        }
    }

    private FieldTypeProtos.DataInfo.Builder getDataInfo(String trust) {
        FieldTypeProtos.DataInfo.Builder builder = FieldTypeProtos.DataInfo.newBuilder().setInferred(true).setProvenanceaction(FieldTypeProtos.Qualifier.newBuilder().setClassid(CLASS_ID).setClassname("Propagation of country information from datasources belonging to institutional repositories").setSchemeid("dnet:provenanceActions").setSchemename("dnet:provenanceActions")).setInferenceprovenance(DATA_INFO_TYPE).setTrust(trust);
        return builder;
    }

    private byte[] getOafCountry(String resultId, String countryValue, String trust) {
        FieldTypeProtos.Qualifier.Builder country = FieldTypeProtos.Qualifier.newBuilder().setClassid(countryValue).setClassname(countryValue).setSchemeid(DNETCOUNTRYSCHEMA).setSchemename(DNETCOUNTRYSCHEMA);
        country.setDataInfo(this.getDataInfo(trust));
        ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder().addCountry(country);
        ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder().setMetadata(metadata);
        OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result).setId(resultId).setResult(result);
        return OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.entity).setEntity(entity).build().toByteArray();
    }
}

