/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.broker.objects.Instance;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.broker.objects.Project;
import eu.dnetlib.broker.objects.Provenance;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.ProtoMapping;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventWrapper;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class ProjectEventFactory
extends ProtoMapping {
    private static String COUNTER_GROUP = "Broker Enrichment projects";
    private Set<String> inferenceProvenance = Sets.newHashSet((Object[])new String[]{"sysimport:mining:repository", "iis"});
    private Set<String> aggregationProvenance = Sets.newHashSet((Object[])new String[]{"sysimport:crosswalk:repository"});
    protected Text tKey = new Text("");

    public static List<EventWrapper> process(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Float trust) throws IOException, InterruptedException, DocumentException {
        return new ProjectEventFactory().processProject(context, current, other, trust);
    }

    public static List<EventWrapper> process(Reducer.Context context, OafProtos.Oaf current) throws IOException, InterruptedException, DocumentException {
        return ProjectEventFactory.process(context, current, null, null);
    }

    private List<EventWrapper> processProject(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Float trust) throws IOException, InterruptedException, DocumentException {
        ArrayList events = Lists.newArrayList();
        if (other == null) {
            for (OafProtos.Oaf oafRel : current.getEntity().getCachedOafRelList()) {
                String provenance = oafRel.getDataInfo().getProvenanceaction().getClassid();
                if (!this.inferenceProvenance.contains(provenance)) continue;
                OafProtos.OafEntity project = oafRel.getRel().getCachedOafTarget().getEntity();
                events.add(this.doProcessProject(context, current, current, project, provenance, Topic.ENRICH_MISSING_PROJECT, this.trust(trust, oafRel)));
            }
        } else {
            for (OafProtos.Oaf currentOafRel : current.getEntity().getCachedOafRelList()) {
                for (OafProtos.Oaf otherOafRel : other.getEntity().getCachedOafRelList()) {
                    String otherTarget;
                    String currentTarget = currentOafRel.getRel().getTarget();
                    if (currentTarget.equals(otherTarget = otherOafRel.getRel().getTarget()) || DedupUtils.isRoot(current.getEntity().getId())) continue;
                    String provenance = otherOafRel.getDataInfo().getProvenanceaction().getClassid();
                    OafProtos.OafEntity project = otherOafRel.getRel().getCachedOafTarget().getEntity();
                    boolean currentHasProject = Iterables.tryFind((Iterable)current.getEntity().getCachedOafRelList(), oaf -> {
                        String currentProjectId = oaf.getRel().getCachedOafTarget().getEntity().getId();
                        return currentProjectId.equals(project.getId());
                    }).isPresent();
                    if (currentHasProject) continue;
                    events.add(this.doProcessProject(context, current, other, project, provenance, Topic.ENRICH_MISSING_PROJECT, this.trust(trust, currentOafRel)));
                }
            }
        }
        return events;
    }

    private EventWrapper doProcessProject(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, OafProtos.OafEntity project, String provenance, Topic topic, Float trust) throws IOException, InterruptedException, DocumentException {
        OafProtos.OafEntity currentEntity = current.getEntity();
        OafProtos.OafEntity otherEntity = other.getEntity();
        Provenance prov = this.getProvenance(otherEntity, provenance);
        OpenAireEventPayload payload = this.addProject(OpenAireEventPayloadFactory.fromOAF(currentEntity, trust.floatValue(), prov), project);
        EventMessage event = EventFactory.asEvent(currentEntity, topic, payload, otherEntity, trust.floatValue());
        event.setPayload(HighlightFactory.highlightEnrichProject(payload, project, provenance).toJSON());
        return EventWrapper.newInstance(event, topic.getValue());
    }

    private OpenAireEventPayload addProject(OpenAireEventPayload payload, OafProtos.OafEntity project) {
        HashMap projects = Maps.newHashMap();
        for (Project prj : payload.getPublication().getProjects()) {
            projects.put(prj.getCode() + prj.getTitle(), prj);
        }
        Project hlProject = ProjectEventFactory.mapRelatedProject(project.getProject());
        projects.put(hlProject.getCode() + hlProject.getTitle(), hlProject);
        payload.getPublication().setProjects((List)Lists.newArrayList(projects.values()));
        return payload;
    }

    private Provenance getProvenance(OafProtos.OafEntity entity, String provenance) {
        if (this.inferenceProvenance.contains(provenance)) {
            return new Provenance().setRepositoryName("OpenAIRE").setUrl("https://beta.openaire.eu/search/publication?articleId=" + StringUtils.substringAfter((String)entity.getId(), (String)"|")).setId((String)Iterables.getFirst((Iterable)entity.getOriginalIdList(), (Object)""));
        }
        return new Provenance().setRepositoryName(OafHbaseUtils.getValue(entity.getCollectedfromList())).setUrl(((Instance)Iterables.getFirst(ProjectEventFactory.mapInstances(entity.getResult().getInstanceList()), (Object)new Instance())).getUrl()).setId(OafHbaseUtils.getValue(entity.getOriginalIdList()));
    }

    private Float trust(Float trust, OafProtos.Oaf oaf) {
        Float provenanceTrust = Float.valueOf(oaf.getDataInfo().getTrust());
        return Float.valueOf(trust != null ? trust.floatValue() * provenanceTrust.floatValue() : provenanceTrust.floatValue());
    }
}

