/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.transform.OafEntityMerger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class UpdateMerger {
    private static final String UPDATE_MERGER = "UPDATE_MERGE";
    private static final String N_MERGES = "N_MERGES";

    public static OafProtos.Oaf mergeBodyUpdates(Mapper.Context context, Map<byte[], byte[]> map) throws InvalidProtocolBufferException {
        HashMap stringMap = Maps.newHashMap();
        for (Map.Entry<byte[], byte[]> e : map.entrySet()) {
            stringMap.put(Bytes.toString((byte[])e.getKey()), e.getValue());
        }
        return UpdateMerger.doMerge(context, stringMap);
    }

    public static OafProtos.Oaf mergeBodyUpdates(Map<String, byte[]> map) throws InvalidProtocolBufferException {
        return UpdateMerger.doMerge(null, map);
    }

    private static OafProtos.Oaf doMerge(Mapper.Context context, Map<String, byte[]> map) throws InvalidProtocolBufferException {
        byte[] value = map.get("body");
        if (value == null) {
            return null;
        }
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)OafProtos.Oaf.parseFrom((byte[])value));
        ArrayList keys = Lists.newArrayList();
        for (String o : map.keySet()) {
            if (!o.startsWith("update_")) continue;
            keys.add(o);
        }
        if (!keys.isEmpty()) {
            Collections.sort(keys);
            for (String k : keys) {
                OafProtos.Oaf update = OafProtos.Oaf.parseFrom((byte[])map.get(k));
                builder.mergeFrom(update);
            }
            builder = OafEntityMerger.merge((OafProtos.Oaf.Builder)builder);
            if (context != null) {
                context.getCounter(UPDATE_MERGER, N_MERGES).increment((long)keys.size());
            }
        }
        return builder.build();
    }
}

