/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventWrapper;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;

public class AbstractEventFactory {
    public static List<EventWrapper> process(OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        return new AbstractEventFactory().processAbstract(current, other, trust);
    }

    private List<EventWrapper> processAbstract(OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        ArrayList events = Lists.newArrayList();
        if (this.hasAbstract(other) && !this.hasAbstract(current)) {
            events.add(this.doProcessAbstract(current, other, Topic.ENRICH_MISSING_ABSTRACT, trust));
        }
        return events;
    }

    private EventWrapper doProcessAbstract(OafProtos.Oaf current, OafProtos.Oaf other, Topic topic, float trust) throws IOException, InterruptedException, DocumentException {
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        List descriptionList = other.getEntity().getResult().getMetadata().getDescriptionList();
        prototype.getEntityBuilder().getResultBuilder().getMetadataBuilder().addAllDescription((Iterable)descriptionList);
        OafProtos.Oaf oaf = prototype.build();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichAbstract(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), descriptionList);
        return EventWrapper.newInstance(EventFactory.asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust), topic.getValue());
    }

    private boolean hasAbstract(OafProtos.Oaf oaf) {
        return oaf.getEntity().getResult().getMetadata().getDescriptionList().stream().anyMatch(s -> StringUtils.isNotBlank((String)s.getValue()));
    }
}

