/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.cc;

import eu.dnetlib.data.mapreduce.hbase.dedup.cc.VertexWritable;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class MindistSearchMapper
extends Mapper<Text, VertexWritable, Text, VertexWritable> {
    private static final Log log = LogFactory.getLog(MindistSearchMapper.class);
    private boolean debug = false;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.debug = context.getConfiguration().getBoolean("mindist_DEBUG", false);
        log.info((Object)("debug mode: " + this.debug));
    }

    protected void map(Text key, VertexWritable value, Mapper.Context context) throws IOException, InterruptedException {
        this.emit(key, value, context);
        if (value.isActivated()) {
            VertexWritable vertex = new VertexWritable();
            for (Text edge : value.getEdges()) {
                if (edge.toString().equals(value.getVertexId().toString())) continue;
                vertex.setVertexId(value.getVertexId());
                vertex.setEdges(null);
                this.emit(edge, vertex, context);
            }
        }
    }

    private void emit(Text key, VertexWritable vertex, Mapper.Context context) throws IOException, InterruptedException {
        context.write((Object)key, (Object)vertex);
        if (this.debug) {
            log.info((Object)vertex.toJSON());
        }
    }
}

