/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventWrapper;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class SubjectEventFactory {
    public static List<EventWrapper> process(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        return new SubjectEventFactory().processSubjectPair(context, current, other, Float.valueOf(trust));
    }

    public static List<EventWrapper> process(Reducer.Context context, OafProtos.Oaf current) throws IOException, InterruptedException, DocumentException {
        return new SubjectEventFactory().processSubjectSingle(context, current);
    }

    private List<EventWrapper> processSubjectSingle(Reducer.Context context, OafProtos.Oaf current) throws InterruptedException, DocumentException, IOException {
        ResultProtos.Result.Metadata mCurrent = current.getEntity().getResult().getMetadata();
        ArrayList events = Lists.newArrayList();
        if (mCurrent.getSubjectList().isEmpty()) {
            for (FieldTypeProtos.StructuredProperty subject : mCurrent.getSubjectList()) {
                if (!subject.hasDataInfo() || !subject.getDataInfo().getInferred()) continue;
                events.add(this.doProcessSubject(context, current, null, subject, this.getSubjectTopic(subject, true), Float.valueOf(subject.getDataInfo().getTrust())));
            }
        }
        return events;
    }

    private List<EventWrapper> processSubjectPair(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Float trust) throws IOException, InterruptedException {
        ResultProtos.Result.Metadata mCurrent = current.getEntity().getResult().getMetadata();
        ResultProtos.Result.Metadata mOther = other.getEntity().getResult().getMetadata();
        ArrayList events = Lists.newArrayList();
        if (mCurrent.getSubjectList().isEmpty()) {
            for (FieldTypeProtos.StructuredProperty subjectOther : mOther.getSubjectList()) {
                events.add(this.doProcessSubject(context, current, other, subjectOther, this.getSubjectTopic(subjectOther, true), trust));
            }
        }
        if (other != null) {
            for (FieldTypeProtos.StructuredProperty subjectOther : mOther.getSubjectList()) {
                if (this.hasSubjectValue(current, subjectOther.getQualifier().getClassid(), subjectOther.getValue())) continue;
                events.add(this.doProcessSubject(context, current, other, subjectOther, this.getSubjectTopic(subjectOther, false), trust));
            }
        }
        return events;
    }

    private EventWrapper doProcessSubject(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, FieldTypeProtos.StructuredProperty subjectOther, Topic topic, Float trust) throws IOException, InterruptedException {
        if (topic == null) {
            context.getCounter("events skipped", "SUBJECT not mapped").increment(1L);
            return null;
        }
        String t = subjectOther.getDataInfo().getTrust();
        float adjustedTrust = trust.floatValue() * Float.valueOf(StringUtils.isBlank((String)t) ? "1.0" : t).floatValue();
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        prototype.getEntityBuilder().getResultBuilder().getMetadataBuilder().addSubject(subjectOther);
        OafProtos.Oaf oaf = prototype.build();
        OafProtos.OafEntity eventEntity = other != null ? other.getEntity() : current.getEntity();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichSubject(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), eventEntity, adjustedTrust), Lists.newArrayList((Object[])new FieldTypeProtos.StructuredProperty[]{subjectOther}));
        return EventWrapper.newInstance(EventFactory.asEvent(oaf.getEntity(), topic, payload, eventEntity, adjustedTrust), topic.getValue());
    }

    private Topic getSubjectTopic(FieldTypeProtos.StructuredProperty subject, boolean missingOrMore) {
        switch (subject.getQualifier().getClassid()) {
            case "mesheuropmc": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_MESHEUROPMC : Topic.ENRICH_MORE_SUBJECT_MESHEUROPMC;
            }
            case "arxiv": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_ARXIV : Topic.ENRICH_MORE_SUBJECT_ARXIV;
            }
            case "jel": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_JEL : Topic.ENRICH_MORE_SUBJECT_JEL;
            }
            case "ddc": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_DDC : Topic.ENRICH_MORE_SUBJECT_DDC;
            }
            case "acm": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_ACM : Topic.ENRICH_MORE_SUBJECT_ACM;
            }
            case "rvk": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_RVK : Topic.ENRICH_MORE_SUBJECT_RVK;
            }
        }
        return null;
    }

    private boolean hasSubjectValue(OafProtos.Oaf oaf, String classId, String value) {
        return oaf.getEntity().getResult().getMetadata().getSubjectList().stream().anyMatch(s -> s.getValue().equalsIgnoreCase(value) & s.getQualifier().getClassid().endsWith(classId));
    }
}

