/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.broker.objects.Instance;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.broker.objects.Provenance;
import eu.dnetlib.broker.objects.Software;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.ProtoMapping;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventWrapper;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class SoftwareEventFactory
extends ProtoMapping {
    private Set<String> inferenceProvenance = Sets.newHashSet((Object[])new String[]{"sysimport:mining:repository", "iis"});

    public static List<EventWrapper> process(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Float trust) throws IOException, InterruptedException, DocumentException {
        return new SoftwareEventFactory().processSoftware(context, current, other, trust);
    }

    public static List<EventWrapper> process(Reducer.Context context, OafProtos.Oaf current) throws IOException, InterruptedException, DocumentException {
        return SoftwareEventFactory.process(context, current, null, null);
    }

    private List<EventWrapper> processSoftware(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Float trust) throws IOException, InterruptedException, DocumentException {
        ArrayList events = Lists.newArrayList();
        if (other == null) {
            for (OafProtos.Oaf oafRel : current.getEntity().getCachedOafRelList()) {
                String provenance = oafRel.getDataInfo().getProvenanceaction().getClassid();
                if (!this.inferenceProvenance.contains(provenance)) continue;
                OafProtos.OafEntity result = oafRel.getRel().getCachedOafTarget().getEntity();
                events.add(this.doProcessSoftware(context, current, current, result, provenance, Topic.ENRICH_MISSING_SOFTWARE, this.trust(trust, oafRel)));
            }
        } else {
            for (OafProtos.Oaf currentOafRel : current.getEntity().getCachedOafRelList()) {
                for (OafProtos.Oaf otherOafRel : other.getEntity().getCachedOafRelList()) {
                    String otherTarget;
                    String currentTarget = currentOafRel.getRel().getTarget();
                    if (currentTarget.equals(otherTarget = otherOafRel.getRel().getTarget())) continue;
                    String provenance = otherOafRel.getDataInfo().getProvenanceaction().getClassid();
                    OafProtos.OafEntity software = otherOafRel.getRel().getCachedOafTarget().getEntity();
                    boolean currentHasSw = Iterables.tryFind((Iterable)current.getEntity().getCachedOafRelList(), oaf -> {
                        String currentSwId = oaf.getRel().getCachedOafTarget().getEntity().getId();
                        return currentSwId.equals(software.getId());
                    }).isPresent();
                    if (currentHasSw) continue;
                    events.add(this.doProcessSoftware(context, current, other, software, provenance, Topic.ENRICH_MISSING_PROJECT, this.trust(trust, currentOafRel)));
                }
            }
        }
        return events;
    }

    private EventWrapper doProcessSoftware(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, OafProtos.OafEntity software, String provenance, Topic topic, Float trust) throws IOException, InterruptedException, DocumentException {
        OafProtos.OafEntity currentEntity = current.getEntity();
        OafProtos.OafEntity otherEntity = other.getEntity();
        Provenance prov = this.getProvenance(otherEntity, provenance);
        OpenAireEventPayload payload = this.addSoftware(OpenAireEventPayloadFactory.fromOAF(currentEntity, trust.floatValue(), prov), software);
        EventMessage event = EventFactory.asEvent(currentEntity, topic, payload, otherEntity, trust.floatValue());
        event.setPayload(HighlightFactory.highlightEnrichSoftware(payload, software, provenance).toJSON());
        return EventWrapper.newInstance(event, topic.getValue());
    }

    private OpenAireEventPayload addSoftware(OpenAireEventPayload payload, OafProtos.OafEntity software) {
        HashMap swMap = Maps.newHashMap();
        for (Software s : payload.getPublication().getSoftwares()) {
            swMap.put(s.getLandingPage(), s);
        }
        Software hlSw = SoftwareEventFactory.mapRelatedSoftware(software.getResult());
        swMap.put(hlSw.getLandingPage(), hlSw);
        payload.getPublication().setSoftwares((List)Lists.newArrayList(swMap.values()));
        return payload;
    }

    private Provenance getProvenance(OafProtos.OafEntity entity, String provenance) {
        if (this.inferenceProvenance.contains(provenance)) {
            return new Provenance().setRepositoryName("OpenAIRE").setUrl("https://beta.openaire.eu/search/publication?articleId=" + StringUtils.substringAfter((String)entity.getId(), (String)"|")).setId((String)Iterables.getFirst((Iterable)entity.getOriginalIdList(), (Object)""));
        }
        return new Provenance().setRepositoryName(OafHbaseUtils.getValue(entity.getCollectedfromList())).setUrl(((Instance)Iterables.getFirst(SoftwareEventFactory.mapInstances(entity.getResult().getInstanceList()), (Object)new Instance())).getUrl()).setId(OafHbaseUtils.getValue(entity.getOriginalIdList()));
    }

    private Float trust(Float trust, OafProtos.Oaf oaf) {
        Float provenanceTrust = Float.valueOf(oaf.getDataInfo().getTrust());
        return Float.valueOf(trust != null ? trust.floatValue() * provenanceTrust.floatValue() : provenanceTrust.floatValue());
    }
}

