/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import com.google.common.collect.Maps;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.mapreduce.hbase.broker.model.MapValue;
import eu.dnetlib.data.mapreduce.hbase.broker.model.MapValueType;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

public class EventFactory {
    private static final String PRODUCER_ID = "OpenAIRE";
    private static final String[] datePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd"};

    public static EventMessage asEvent(OafProtos.OafEntity oaf, Topic topic, OpenAireEventPayload payload, OafProtos.OafEntity source, float trust) {
        return EventFactory.asEvent(oaf, topic, payload, OafHbaseUtils.getKey(source.getCollectedfromList()), OafHbaseUtils.getValue(source.getCollectedfromList()), trust, OafHbaseUtils.listValues(source.getOriginalIdList()));
    }

    public static EventMessage asEvent(OafProtos.OafEntity oaf, Topic topic, OpenAireEventPayload payload, String sourceDatasourceId, String sourceDatasourceName, float trust) {
        return EventFactory.asEvent(oaf, topic, payload, sourceDatasourceId, sourceDatasourceName, trust, null);
    }

    public static EventMessage asEvent(OafProtos.OafEntity oaf, Topic topic, OpenAireEventPayload payload, String sourceDatasourceId, String sourceDatasourceName, float trust, List<String> sourceOriginalIds) {
        List<String> authors;
        List<String> subjects;
        String date;
        String title;
        String targetDatasourceName;
        HashMap map = Maps.newHashMap();
        String targetDatasourceId = OafHbaseUtils.getKey(oaf.getCollectedfromList());
        if (StringUtils.isNotBlank((String)targetDatasourceId)) {
            map.put("target_datasource_id", new MapValue(MapValueType.STRING, targetDatasourceId));
        }
        if (StringUtils.isNotBlank((String)(targetDatasourceName = OafHbaseUtils.getValue(oaf.getCollectedfromList())))) {
            map.put("target_datasource_name", new MapValue(MapValueType.STRING, targetDatasourceName));
        }
        if (StringUtils.isNotBlank((String)(title = OafHbaseUtils.getValue(oaf.getResult().getMetadata().getTitleList())))) {
            map.put("target_publication_title", new MapValue(MapValueType.STRING, title));
        }
        if (EventFactory.isValidDate(date = oaf.getResult().getMetadata().getDateofacceptance().getValue())) {
            map.put("target_dateofacceptance", new MapValue(MapValueType.DATE, date));
        }
        if (CollectionUtils.isNotEmpty(subjects = OafHbaseUtils.listValues(oaf.getResult().getMetadata().getSubjectList()))) {
            map.put("target_publication_subject_list", new MapValue(MapValueType.LIST_STRING, subjects));
        }
        if (CollectionUtils.isNotEmpty(authors = OafHbaseUtils.listValues(oaf.getResult().getMetadata().getAuthorList()))) {
            map.put("target_publication_author_list", new MapValue(MapValueType.LIST_STRING, authors));
        }
        map.put("target_publication_id", new MapValue(MapValueType.STRING, OafHbaseUtils.getValue(oaf.getOriginalIdList())));
        map.put("trust", new MapValue(MapValueType.FLOAT, Float.valueOf(trust)));
        if (StringUtils.isNotBlank((String)sourceDatasourceName)) {
            map.put("provenance_datasource_name", new MapValue(MapValueType.STRING, sourceDatasourceName));
        }
        if (StringUtils.isNotBlank((String)sourceDatasourceId)) {
            map.put("provenance_datasource_id", new MapValue(MapValueType.STRING, sourceDatasourceId));
        }
        if (sourceOriginalIds != null && !sourceOriginalIds.isEmpty()) {
            map.put("provenance_publication_id_list", new MapValue(MapValueType.LIST_STRING, sourceOriginalIds));
        }
        return new EventMessage(PRODUCER_ID, topic, payload.toJSON(), -1, map);
    }

    private static boolean isValidDate(String date) {
        if (StringUtils.isBlank((String)date)) {
            return false;
        }
        try {
            DateUtils.parseDate((String)date, (String[])datePatterns);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

