/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventWrapper;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dom4j.DocumentException;

public class PIDEventFactory {
    public static List<EventWrapper> process(OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        return new PIDEventFactory().processPID(current, other, trust);
    }

    public List<EventWrapper> processPID(OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        List pids = other.getEntity().getPidList();
        return Stream.concat(pids.stream().map(p -> this.doProcessPID(current, other, (FieldTypeProtos.StructuredProperty)p, Topic.ENRICH_MISSING_PID, trust)), pids.stream().filter(p -> !this.hasPidValue(current, p.getValue())).map(p -> this.doProcessPID(current, other, (FieldTypeProtos.StructuredProperty)p, Topic.ENRICH_MORE_PID, trust))).collect(Collectors.toList());
    }

    private EventWrapper doProcessPID(OafProtos.Oaf current, OafProtos.Oaf other, FieldTypeProtos.StructuredProperty pidOther, Topic topic, float trust) {
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        prototype.getEntityBuilder().addPid(pidOther);
        OafProtos.Oaf oaf = prototype.build();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichPid(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), Lists.newArrayList((Object[])new FieldTypeProtos.StructuredProperty[]{pidOther}));
        return EventWrapper.newInstance(EventFactory.asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust), topic.getValue());
    }

    private boolean hasPidValue(OafProtos.Oaf oaf, String value) {
        return oaf.getEntity().getPidList().stream().anyMatch(pid -> pid.getValue().equalsIgnoreCase(value));
    }
}

