/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import eu.dnetlib.broker.objects.ExternalReference;
import eu.dnetlib.broker.objects.Instance;
import eu.dnetlib.broker.objects.Journal;
import eu.dnetlib.broker.objects.Pid;
import eu.dnetlib.broker.objects.Project;
import eu.dnetlib.broker.objects.Software;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public abstract class ProtoMapping {
    protected static List<Instance> mapInstances(List<ResultProtos.Result.Instance> in) {
        return in.stream().map(i -> new Instance().setHostedby(OafHbaseUtils.getValue(i.getHostedby())).setInstancetype(OafHbaseUtils.getValue(i.getInstancetype())).setLicense(OafHbaseUtils.getKey(i.getAccessright())).setUrl((String)Iterables.getFirst((Iterable)i.getUrlList(), (Object)""))).collect(Collectors.toList());
    }

    protected static List<Pid> mapPids(List<FieldTypeProtos.StructuredProperty> sp) {
        return sp.stream().map(s -> new Pid().setType(s.getQualifier().getClassid()).setValue(s.getValue())).collect(Collectors.toList());
    }

    protected static Journal mapJournal(ResultProtos.Result.Journal j) {
        return new Journal().setName(j.getName()).setIssn(j.getIssnPrinted()).setEissn(j.getIssnOnline()).setLissn(j.getIssnLinking());
    }

    protected static List<ExternalReference> mapExternalRefs(List<ResultProtos.Result.ExternalReference> ext) {
        return ext.stream().map(e -> new ExternalReference().setUrl(e.getUrl()).setType(OafHbaseUtils.getKey(e.getQualifier())).setRefidentifier(e.getRefidentifier()).setSitename(e.getSitename())).collect(Collectors.toList());
    }

    protected static final List<Project> mapRelatedProjects(OafProtos.OafEntity entity) {
        HashMap projectMap = Maps.newHashMap();
        for (OafProtos.Oaf rel : entity.getCachedOafRelList()) {
            OafProtos.OafEntity p = rel.getRel().getCachedOafTarget().getEntity();
            projectMap.put(p.getId(), OafProtos.Oaf.newBuilder((OafProtos.Oaf)rel).build());
        }
        return projectMap.values().stream().map(o -> ProtoMapping.mapRelatedProject(o.getRel().getCachedOafTarget().getEntity().getProject())).collect(Collectors.toList());
    }

    protected static final Project mapRelatedProject(ProjectProtos.Project project) {
        Project p = new Project();
        ProjectProtos.Project.Metadata mp = project.getMetadata();
        p.setCode(OafHbaseUtils.getValue(mp.getCode()));
        p.setAcronym(OafHbaseUtils.getValue(mp.getAcronym()));
        p.setTitle(OafHbaseUtils.getValue(mp.getTitle()));
        String ftree = OafHbaseUtils.getValue(mp.getFundingtreeList());
        if (StringUtils.isNotBlank((String)ftree)) {
            try {
                Document fdoc = new SAXReader().read((Reader)new StringReader(ftree));
                p.setFunder(fdoc.valueOf("/fundingtree/funder/shortname"));
                p.setJurisdiction(fdoc.valueOf("/fundingtree/funder/jurisdiction"));
                p.setFundingProgram(fdoc.valueOf("//funding_level_0/name"));
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        }
        return p;
    }

    protected static final Software mapRelatedSoftware(ResultProtos.Result result) {
        Software s = new Software();
        ResultProtos.Result.Metadata rp = result.getMetadata();
        s.setName(OafHbaseUtils.getValue(rp.getTitleList()));
        s.setDescription(OafHbaseUtils.getValue(rp.getDescriptionList()));
        s.setLandingPage(OafHbaseUtils.getValue(rp.getCodeRepositoryUrl()));
        if (result.getInstanceList() != null && result.getInstanceList().size() > 0) {
            s.setRepository(OafHbaseUtils.getValue(((ResultProtos.Result.Instance)result.getInstanceList().get(0)).getUrlList()));
        }
        return s;
    }
}

