/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventWrapper;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;

public class PublicationDateEventFactory {
    public static List<EventWrapper> process(OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        return new PublicationDateEventFactory().processPublicationDate(current, other, trust);
    }

    private List<EventWrapper> processPublicationDate(OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        ArrayList events = Lists.newArrayList();
        if (this.hasPubDate(other) && !this.hasPubDate(current)) {
            events.add(this.doProcessPublicationDate(current, other, Topic.ENRICH_MISSING_PUBLICATION_DATE, trust));
        }
        return events;
    }

    private EventWrapper doProcessPublicationDate(OafProtos.Oaf current, OafProtos.Oaf other, Topic topic, float trust) throws IOException, InterruptedException, DocumentException {
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        FieldTypeProtos.StringField date = other.getEntity().getResult().getMetadata().getDateofacceptance();
        prototype.getEntityBuilder().getResultBuilder().getMetadataBuilder().setDateofacceptance(date);
        OafProtos.Oaf oaf = prototype.build();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichPublicationDate(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), date);
        return EventWrapper.newInstance(EventFactory.asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust), topic.getValue());
    }

    private boolean hasPubDate(OafProtos.Oaf current) {
        ResultProtos.Result.Metadata m = current.getEntity().getResult().getMetadata();
        return StringUtils.isNotBlank((String)m.getDateofacceptance().getValue());
    }
}

