package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

import java.io.IOException;

public class CrossRefImportMapper extends Mapper<LongWritable, Text, Text, Text> {

    private String setName;
    private Agent agent;
    private Text keyout;
    private Text valueOut;
    private JsonParser parser;
    private ActionFactory factory;
    private boolean invisible;

    @Override
    protected void setup(Context context) throws IOException, InterruptedException {
        setName = context.getConfiguration().get("setName");
        agent = new Agent(context.getConfiguration().get("agentId"), context.getConfiguration().get("agentName"), Agent.AGENT_TYPE.service);
        keyout = new Text("");
        valueOut = new Text("");
        factory = new ActionFactory();
        parser = new JsonParser();
        invisible = context.getConfiguration().getBoolean("invisible", false);
    }

    @Override
    protected void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {
        final String inputJson = value.toString();
        final JsonObject rootElement = parser.parse(inputJson).getAsJsonObject();
        try {
            final AtomicAction action = CrossRefToActions.generateActionsFromDump(rootElement, factory, setName, agent, invisible);

            keyout.set(action.getRowKey());
            valueOut.set(action.toJSON());
            context.write(keyout, valueOut);

        } catch (Throwable e) {
            System.err.println(inputJson);
            throw e;
        }


    }


}
