/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import eu.dnetlib.data.mapreduce.Algorithms;
import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.DedupSimilarityProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.OrganizationOrganizationProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.pace.config.DedupConfig;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class DedupUtils {
    public static final String CF_SEPARATOR = "_";
    public static final String ROOT = "dedup_wf";
    public static final String BODY_S = "body";
    public static final byte[] BODY_B = Bytes.toBytes((String)"body");

    public static String dedupPrefix(String dedupRun) {
        return "|dedup_wf_" + dedupRun + "::";
    }

    public static String newId(String id, String dedupRun) {
        if (dedupRun == null || dedupRun.length() != 3) {
            throw new IllegalArgumentException("wrong dedupRun param");
        }
        return id.replaceFirst("\\|.*\\:\\:", DedupUtils.dedupPrefix(dedupRun));
    }

    public static byte[] newIdBytes(String s, String dedupRun) {
        return DedupUtils.newId(s, dedupRun).getBytes();
    }

    public static byte[] newIdBytes(ByteBuffer b, String dedupRun) {
        return DedupUtils.newId(new String(b.array()), dedupRun).getBytes();
    }

    public static boolean isRoot(String s) {
        return s.contains(ROOT);
    }

    public static boolean isRoot(ImmutableBytesWritable s) {
        return DedupUtils.isRoot(s.copyBytes());
    }

    public static boolean isRoot(byte[] s) {
        return DedupUtils.isRoot(new String(s));
    }

    public static String getDedupCF_merges(TypeProtos.Type type) {
        return DedupUtils.getRelType(type) + CF_SEPARATOR + RelTypeProtos.SubRelType.dedup + CF_SEPARATOR + DedupProtos.Dedup.RelName.merges;
    }

    public static String getDedupCF_merges(String type) {
        return DedupUtils.getDedupCF_merges(TypeProtos.Type.valueOf((String)type));
    }

    public static byte[] getDedupCF_mergesBytes(TypeProtos.Type type) {
        return Bytes.toBytes((String)DedupUtils.getDedupCF_merges(type));
    }

    public static byte[] getDedupCF_mergesBytes(String type) {
        return DedupUtils.getDedupCF_mergesBytes(TypeProtos.Type.valueOf((String)type));
    }

    public static String getDedupCF_mergedIn(TypeProtos.Type type) {
        return DedupUtils.getRelType(type) + CF_SEPARATOR + RelTypeProtos.SubRelType.dedup + CF_SEPARATOR + DedupProtos.Dedup.RelName.isMergedIn;
    }

    public static String getDedupCF_mergedIn(String type) {
        return DedupUtils.getDedupCF_mergedIn(TypeProtos.Type.valueOf((String)type));
    }

    public static byte[] getDedupCF_mergedInBytes(TypeProtos.Type type) {
        return Bytes.toBytes((String)DedupUtils.getDedupCF_mergedIn(type));
    }

    public static byte[] getDedupCF_mergedInBytes(String type) {
        return DedupUtils.getDedupCF_mergedInBytes(TypeProtos.Type.valueOf((String)type));
    }

    public static String getSimilarityCF(TypeProtos.Type type) {
        return DedupUtils.getRelType(type) + CF_SEPARATOR + RelTypeProtos.SubRelType.dedupSimilarity + CF_SEPARATOR + DedupSimilarityProtos.DedupSimilarity.RelName.isSimilarTo;
    }

    public static String getSimilarityCF(String type) {
        return DedupUtils.getSimilarityCF(TypeProtos.Type.valueOf((String)type));
    }

    public static byte[] getSimilarityCFBytes(TypeProtos.Type type) {
        return Bytes.toBytes((String)DedupUtils.getSimilarityCF(type));
    }

    public static byte[] getSimilarityCFBytes(String type) {
        return DedupUtils.getSimilarityCFBytes(TypeProtos.Type.valueOf((String)type));
    }

    public static String getRelTypeString(TypeProtos.Type type) {
        return DedupUtils.getRelType(type).toString();
    }

    public static RelTypeProtos.RelType getRelType(TypeProtos.Type type) {
        switch (type) {
            case organization: {
                return RelTypeProtos.RelType.organizationOrganization;
            }
            case result: {
                return RelTypeProtos.RelType.resultResult;
            }
        }
        throw new IllegalArgumentException("Deduplication not supported for entity type: " + type);
    }

    public static ColumnFamily decodeCF(byte[] b) {
        String[] s = new String(b).split(CF_SEPARATOR);
        return new DedupUtils().getCF(RelTypeProtos.RelType.valueOf((String)s[0]), RelTypeProtos.SubRelType.valueOf((String)s[1]));
    }

    private ColumnFamily getCF(RelTypeProtos.RelType relType, RelTypeProtos.SubRelType subRelType) {
        return new ColumnFamily(relType, subRelType);
    }

    public static OafProtos.OafRel.Builder getDedup(DedupConfig dedupConf, String from, String to, DedupProtos.Dedup.RelName relClass) {
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)dedupConf.getWf().getEntityType());
        OafProtos.OafRel.Builder oafRel = DedupUtils.getRelBuilder(from, to, relClass.name(), DedupUtils.getRelType(type));
        switch (type) {
            case organization: {
                oafRel.setOrganizationOrganization(OrganizationOrganizationProtos.OrganizationOrganization.newBuilder().setDedup(DedupUtils.dedup(relClass.name(), "dnet:organization_organization_relations")));
                break;
            }
            case result: {
                oafRel.setResultResult(ResultResultProtos.ResultResult.newBuilder().setDedup(DedupUtils.dedup(relClass.name(), "dnet:result_result_relations")));
                break;
            }
            default: {
                throw new IllegalArgumentException("Deduplication not supported for entity type: " + dedupConf.getWf().getEntityType());
            }
        }
        return oafRel;
    }

    public static OafProtos.OafRel.Builder getDedupSimilarity(DedupConfig dedupConf, String from, String to) {
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)dedupConf.getWf().getEntityType());
        String isSimilarTo = DedupSimilarityProtos.DedupSimilarity.RelName.isSimilarTo.name();
        OafProtos.OafRel.Builder oafRel = DedupUtils.getRelBuilder(from, to, isSimilarTo, DedupUtils.getRelType(type));
        switch (type) {
            case organization: {
                oafRel.setOrganizationOrganization(OrganizationOrganizationProtos.OrganizationOrganization.newBuilder().setDedupSimilarity(DedupUtils.dedupSimilarity(isSimilarTo, "dnet:organization_organization_relations")));
                break;
            }
            case result: {
                oafRel.setResultResult(ResultResultProtos.ResultResult.newBuilder().setDedupSimilarity(DedupUtils.dedupSimilarity(isSimilarTo, "dnet:result_result_relations")));
                break;
            }
            default: {
                throw new IllegalArgumentException("Deduplication not supported for entity type: " + dedupConf.getWf().getEntityType());
            }
        }
        return oafRel;
    }

    private static OafProtos.OafRel.Builder getRelBuilder(String from, String to, String relClass, RelTypeProtos.RelType relType) {
        return OafProtos.OafRel.newBuilder().setRelType(relType).setSubRelType(RelTypeProtos.SubRelType.dedup).setRelClass(relClass).setChild(false).setSource(new String(from)).setTarget(new String(to));
    }

    private static DedupProtos.Dedup.Builder dedup(String relClass, String scheme) {
        return DedupProtos.Dedup.newBuilder().setRelMetadata(DedupUtils.getRelMetadata(relClass, scheme));
    }

    private static DedupSimilarityProtos.DedupSimilarity.Builder dedupSimilarity(String relClass, String scheme) {
        return DedupSimilarityProtos.DedupSimilarity.newBuilder().setRelMetadata(DedupUtils.getRelMetadata(relClass, scheme));
    }

    private static RelMetadataProtos.RelMetadata.Builder getRelMetadata(String relClass, String scheme) {
        return RelMetadataProtos.RelMetadata.newBuilder().setSemantics(FieldTypeProtos.Qualifier.newBuilder().setClassid(relClass).setClassname(relClass).setSchemeid(scheme).setSchemename(scheme));
    }

    public static OafProtos.Oaf.Builder buildRel(DedupConfig dedupConf, OafProtos.OafRel.Builder oafRel, double trust) {
        double sTrust = Algorithms.scale(trust, 0.9);
        OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.relation).setLastupdatetimestamp(System.currentTimeMillis()).setDataInfo(AbstractDNetXsltFunctions.getDataInfo(null, (String)"", (String)String.valueOf(sTrust), (boolean)false, (boolean)true).setInferenceprovenance(dedupConf.getWf().getConfigurationId())).setRel(oafRel);
        return oaf;
    }

    class ColumnFamily {
        private final RelTypeProtos.RelType relType;
        private final RelTypeProtos.SubRelType subRelType;

        public ColumnFamily(RelTypeProtos.RelType relType, RelTypeProtos.SubRelType subRelType) {
            this.relType = relType;
            this.subRelType = subRelType;
        }

        public String toString() {
            return this.getRelType() + DedupUtils.CF_SEPARATOR + this.getSubRelType();
        }

        public RelTypeProtos.RelType getRelType() {
            return this.relType;
        }

        public RelTypeProtos.SubRelType getSubRelType() {
            return this.subRelType;
        }
    }
}

