/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.mapreduce.hbase.index.config.RelClasses;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.mapreduce.util.OafRelDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.transform.OafEntityMerger;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class DedupBuildRootsReducer
extends TableReducer<Text, ImmutableBytesWritable, ImmutableBytesWritable> {
    private DedupConfig dedupConf;
    private RelClasses relClasses;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup buildRoots reducer\n\nwf conf: " + this.dedupConf.toString());
        String relClassJson = context.getConfiguration().get("relClasses");
        System.out.println("relClassesJson:\n" + relClassJson);
        this.relClasses = RelClasses.fromJSon(relClassJson);
        System.out.println("relClasses:\n" + this.relClasses);
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        if (!DedupUtils.isRoot(key.toString())) {
            System.err.println("aborting DedupBuildRootsReducer, found non-root key: " + key);
            context.getCounter("DedupBuildRootsReducer", "aborted").increment(1L);
            return;
        }
        byte[] rowkey = Bytes.toBytes((String)key.toString());
        ArrayList entities = Lists.newArrayList();
        for (OafProtos.Oaf oaf : this.toOaf(values)) {
            switch (oaf.getKind()) {
                case entity: {
                    entities.add(oaf);
                    break;
                }
                case relation: {
                    this.handleRels(context, rowkey, oaf);
                    break;
                }
            }
        }
        OafProtos.Oaf.Builder builder = OafEntityMerger.merge((DedupConfig)this.dedupConf, (String)key.toString(), (Iterable)entities);
        if (entities.size() < 20) {
            context.getCounter(this.dedupConf.getWf().getEntityType() + " root group size", this.lpad(entities.size())).increment(1L);
        } else {
            context.getCounter(this.dedupConf.getWf().getEntityType() + " root group size", "> 20").increment(1L);
        }
        this.emit(builder.getEntity().getType().toString(), context, rowkey, this.dedupConf.getWf().getEntityType(), "body", builder.build().toByteArray(), "root");
    }

    private Iterable<OafProtos.Oaf> toOaf(Iterable<ImmutableBytesWritable> values) {
        return Iterables.transform(values, OafHbaseUtils.oafDecoder());
    }

    private void handleRels(Reducer.Context context, byte[] rowkey, OafProtos.Oaf oaf) throws IOException, InterruptedException {
        OafDecoder decoder = this.rootToEntity(rowkey, oaf);
        this.emit("emit relation from the root to the related entities", context, rowkey, decoder.getCFQ(), decoder.relTargetId(), decoder.toByteArray(), "[root -> entity]");
        decoder = this.entityToRoot(rowkey, oaf);
        byte[] revKey = Bytes.toBytes((String)decoder.relSourceId());
        this.emit("emit relation from the related entities to the root", context, revKey, decoder.getCFQ(), new String(rowkey), decoder.toByteArray(), "[entity -> root]");
        decoder = this.markDeleted(oaf, true);
        revKey = Bytes.toBytes((String)decoder.relSourceId());
        this.emit("mark relation from the related entities to the duplicate as deleted", context, revKey, decoder.getCFQ(), decoder.relTargetId(), decoder.toByteArray(), "mark deleted [dup -> entity]");
        decoder = this.markDeleted(oaf, false);
        revKey = Bytes.toBytes((String)decoder.relSourceId());
        this.emit("mark relation from the related entities to the duplicate as deleted", context, revKey, decoder.getCFQ(), decoder.relTargetId(), decoder.toByteArray(), "mark deleted [entity -> dup]");
    }

    private void emit(String msg, Reducer.Context context, byte[] rowkey, String family, String qualifier, byte[] value, String label) throws IOException, InterruptedException {
        Put put = new Put(rowkey).add(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier), value);
        put.setDurability(Durability.SKIP_WAL);
        try {
            context.write((Object)new ImmutableBytesWritable(rowkey), (Object)put);
        }
        catch (RetriesExhaustedWithDetailsException | NoSuchColumnFamilyException e) {
            System.err.println(String.format("%s, rowkey %s, family %s, qualifier %s", msg, new String(rowkey), family, qualifier));
            throw new RuntimeException(e);
        }
        context.getCounter(family, label).increment(1L);
    }

    private OafDecoder rootToEntity(byte[] rootRowkey, OafProtos.Oaf rel) {
        return this.patchRelations(rootRowkey, rel, OafPatch.rootToEntity);
    }

    private OafDecoder entityToRoot(byte[] rootRowkey, OafProtos.Oaf rel) {
        return this.patchRelations(rootRowkey, rel, OafPatch.entityToRoot);
    }

    private OafDecoder markDeleted(OafProtos.Oaf rel, boolean reverse) {
        return this.deleteRelations(rel, reverse);
    }

    private OafDecoder patchRelations(byte[] rootRowkey, OafProtos.Oaf rel, OafPatch patchKind) {
        String id = new String(rootRowkey);
        OafRelDecoder decoder = OafRelDecoder.decode((OafProtos.OafRel)rel.getRel());
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)rel);
        builder.getDataInfoBuilder().setInferred(true).setDeletedbyinference(false);
        switch (patchKind) {
            case rootToEntity: {
                builder.getRelBuilder().setSource(id);
                break;
            }
            case entityToRoot: {
                String relClass = rel.getRel().getRelClass();
                String inverse = this.relClasses.getInverse(relClass);
                if (StringUtils.isBlank((String)inverse)) {
                    throw new IllegalStateException(String.format("missing inverse relation for %s in row %s", relClass, id));
                }
                builder.setRel(decoder.setClassId(inverse));
                builder.getRelBuilder().setSource(builder.getRel().getTarget());
                builder.getRelBuilder().setTarget(id);
                break;
            }
        }
        return OafDecoder.decode((OafProtos.Oaf)builder.build());
    }

    private OafDecoder deleteRelations(OafProtos.Oaf rel, boolean reverse) {
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)rel);
        builder.getDataInfoBuilder().setDeletedbyinference(true);
        if (reverse) {
            OafRelDecoder decoder = OafRelDecoder.decode((OafProtos.OafRel)rel.getRel());
            builder.setRel(decoder.setClassId(this.relClasses.getInverse(rel.getRel().getRelClass())));
            String tmp = builder.getRel().getSource();
            builder.getRelBuilder().setSource(builder.getRel().getTarget());
            builder.getRelBuilder().setTarget(tmp);
        }
        return OafDecoder.decode((OafProtos.Oaf)builder.build());
    }

    private String lpad(int s) {
        return StringUtils.leftPad((String)String.valueOf(s), (int)5);
    }

    private static enum OafPatch {
        rootToEntity,
        entityToRoot;

    }
}

