/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.cc;

import eu.dnetlib.data.mapreduce.hbase.dedup.cc.VertexWritable;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.StreamUtils;
import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class ConnectedComponentsReducer
extends TableReducer<Text, VertexWritable, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(ConnectedComponentsReducer.class);
    private DedupConfig dedupConf;
    private byte[] cfMergedIn;
    private byte[] cfMerges;

    protected void setup(Reducer.Context context) {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        log.info((Object)("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString()));
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType());
        this.cfMergedIn = DedupUtils.getDedupCF_mergedInBytes(type);
        this.cfMerges = DedupUtils.getDedupCF_mergesBytes(type);
    }

    protected void reduce(Text key, Iterable<VertexWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        byte[] root = DedupUtils.newIdBytes(ByteBuffer.wrap(Bytes.toBytes((String)key.toString())), this.dedupConf.getWf().getDedupRun());
        StreamUtils.toStream(values.iterator()).flatMap(v -> v.getEdges().stream()).forEach(q -> {
            byte[] qb = Bytes.toBytes((String)q.toString());
            this.emitDedupRel(context, this.cfMergedIn, qb, root, this.buildRel(qb, root, DedupProtos.Dedup.RelName.isMergedIn));
            this.emitDedupRel(context, this.cfMerges, root, qb, this.buildRel(root, qb, DedupProtos.Dedup.RelName.merges));
            context.getCounter(this.dedupConf.getWf().getEntityType(), "dedupRel (x2)").increment(1L);
        });
    }

    private void emitDedupRel(Reducer.Context context, byte[] cf, byte[] from, byte[] to, byte[] value) {
        Put put = new Put(from).add(cf, to, value);
        put.setDurability(Durability.SKIP_WAL);
        try {
            context.write((Object)new ImmutableBytesWritable(from), (Object)put);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] buildRel(byte[] from, byte[] to, DedupProtos.Dedup.RelName relClass) {
        OafProtos.OafRel.Builder oafRef = DedupUtils.getDedup(this.dedupConf, new String(from), new String(to), relClass);
        OafProtos.Oaf oaf = DedupUtils.buildRel(this.dedupConf, oafRef, 0.8).build();
        return oaf.toByteArray();
    }
}

