package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;

/**
 * Created by claudio on 21/02/2017.
 */
public abstract class AbstractEnrichmentMapper extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {

	protected ImmutableBytesWritable outValue;

	protected ImmutableBytesWritable outKey;

	protected abstract String counterGroup();

	@Override
	protected void setup(final Context context) {
		outKey = new ImmutableBytesWritable();
		outValue = new ImmutableBytesWritable();
	}

	protected void emit(final Context context, final byte[] key, final byte[] value, final String entityType) {
		outKey.set(key);
		outValue.set(value);
		try {
			context.write(outKey, outValue);
			context.getCounter(counterGroup(), "entity type: " + entityType).increment(1);
		} catch (Exception e) {
			throw new IllegalArgumentException(e);
		}
	}

}
