/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import com.google.common.collect.Iterables;
import eu.dnetlib.data.mapreduce.hbase.broker.enrich.AbstractEnrichmentMapper;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.mapreduce.util.UpdateMerger;
import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class EnrichmentMapper
extends AbstractEnrichmentMapper {
    @Override
    protected String counterGroup() {
        return "Broker Enrichment";
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        String type = OafRowKeyDecoder.decode((byte[])key.copyBytes()).getType().toString();
        NavigableMap result = value.getFamilyMap(Bytes.toBytes((String)TypeProtos.Type.result.name()));
        if (MapUtils.isEmpty((Map)result)) {
            context.getCounter(this.counterGroup(), type + ": empty family map").increment(1L);
            return;
        }
        OafProtos.Oaf body = UpdateMerger.mergeBodyUpdates(context, result);
        if (body == null) {
            context.getCounter(this.counterGroup(), type + ": body null").increment(1L);
            return;
        }
        String mergedInCF = DedupUtils.getDedupCF_mergedIn(TypeProtos.Type.result);
        NavigableMap mergedIn = value.getFamilyMap(Bytes.toBytes((String)mergedInCF));
        byte[] outKey = this.getEmitKey(context, key, mergedIn);
        this.emit(context, outKey, body.toByteArray(), type);
    }

    private byte[] getEmitKey(Mapper.Context context, ImmutableBytesWritable key, Map<byte[], byte[]> mergedIn) {
        if (MapUtils.isNotEmpty(mergedIn)) {
            context.getCounter(TypeProtos.Type.result.name(), DedupProtos.Dedup.RelName.isMergedIn.name()).increment(1L);
            return (byte[])Iterables.getOnlyElement(mergedIn.keySet());
        }
        return key.copyBytes();
    }
}

