package eu.dnetlib.data.mapreduce.hbase.dedup.cc;

/**
 * Created by claudio on 14/10/15.
 */

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class MindistSearchReducer extends Reducer<Text, VertexWritable, Text, VertexWritable> {

	private static final Log log = LogFactory.getLog(MindistSearchReducer.class);

	public static final String UPDATE_COUNTER = "UpdateCounter";
	public static final String SKIPPED = "SKIPPED";
	public static final String UPDATED = "UPDATED";

	private boolean depthOne;

	private boolean debug = false;

	@Override
	protected void setup(Context context) throws IOException, InterruptedException {
		super.setup(context);
		final String recursionDepth = context.getConfiguration().get("mindist_recursion_depth");
		log.info("got recursion depth: " + recursionDepth);
		if (Integer.parseInt(recursionDepth) == 0) {
			depthOne = true;
		}

		debug = context.getConfiguration().getBoolean("mindist_DEBUG", false);
		log.info("debug mode: " + debug);
	}

	@Override
	protected void reduce(Text key, Iterable<VertexWritable> values, Context context) throws IOException, InterruptedException {

		VertexWritable realVertex = null;
		Text currentMinimalKey = null;
		//boolean foundEdges = false;

		if (depthOne) {
			for (VertexWritable vertex : values) {
				if (!vertex.isMessage()) {
					//log.info(String.format("found vertex with edges: %s", key.toString()));
					realVertex = vertex.clone();
				}
			}

			if (realVertex == null) {
				context.getCounter(UPDATE_COUNTER, SKIPPED).increment(1);
				return;
			}

			realVertex.setActivated(true);
			realVertex.setVertexId(realVertex.getEdges().first());

			if (key.compareTo(realVertex.getVertexId()) < 0) {
				realVertex.setVertexId(key);
			}

			context.getCounter(UPDATE_COUNTER, UPDATED).increment(1);
		} else {
			for (VertexWritable vertex : values) {
				if (!vertex.isMessage()) {
					if (realVertex == null) {
						realVertex = vertex.clone();
					}
				} else {
					if (currentMinimalKey == null) {
						currentMinimalKey = new Text(vertex.getVertexId());
					} else {

						if (currentMinimalKey.compareTo(vertex.getVertexId()) > 0) {
							currentMinimalKey = new Text(vertex.getVertexId());
						}
					}
				}
			}

			if (realVertex == null) {
				context.getCounter(UPDATE_COUNTER, SKIPPED).increment(1);
				return;
			}

			if (currentMinimalKey != null && currentMinimalKey.compareTo(realVertex.getVertexId()) < 0) {
				realVertex.setVertexId(currentMinimalKey);
				realVertex.setActivated(true);
				context.getCounter(UPDATE_COUNTER, UPDATED).increment(1);
			} else {
				realVertex.setActivated(false);
			}
		}

		context.write(key, realVertex);
		if (debug) {
			log.info(realVertex.toJSON());
		}
	}

}
