/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataexport;

import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class ExportSimplifiedRecordsMapper
extends Mapper<Text, Text, Text, Text> {
    private static final Log log = LogFactory.getLog(ExportSimplifiedRecordsMapper.class);
    private ApplyXslt recordSummarizer;
    private Text valueOut;
    private Text keyOut;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        String xslt = new String(Base64.decodeBase64((String)context.getConfiguration().get("xslt")));
        log.info((Object)("got xslt: \n" + xslt));
        this.recordSummarizer = new ApplyXslt(xslt);
        this.valueOut = new Text();
        this.keyOut = new Text("");
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String summary = this.recordSummarizer.evaluate((Object)value.toString());
        if (StringUtils.isNotBlank((String)summary)) {
            this.valueOut.set(summary.replaceAll("\n", "").replaceAll("\t", ""));
            context.write((Object)this.keyOut, (Object)this.valueOut);
        }
    }
}

