/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextMapper;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.IndexConfig;
import eu.dnetlib.data.mapreduce.hbase.index.config.RelClasses;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.mapreduce.util.XmlRecordFactory;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class PrepareFeedReducer
extends Reducer<Text, ImmutableBytesWritable, Text, Text> {
    private static final Log log = LogFactory.getLog(PrepareFeedReducer.class);
    private EntityConfigTable entityConfigTable;
    private ContextMapper contextMapper = new ContextMapper();
    private RelClasses relClasses;
    private Set<String> otherDatasourceTypesUForUI;
    private String schemaLocation;
    private final boolean entityDefaults = true;
    private final boolean relDefaults = false;
    private final boolean childDefaults = false;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        String json = context.getConfiguration().get("index.entity.links");
        log.info((Object)("index.entity.links:\n" + json));
        this.entityConfigTable = IndexConfig.load(json).getConfigMap();
        this.schemaLocation = context.getConfiguration().get("oaf.schema.location");
        log.info((Object)("schema location:\n" + this.schemaLocation));
        String contextMap = context.getConfiguration().get("contextmap");
        log.info((Object)("contextmap:\n" + contextMap));
        try {
            this.contextMapper = ContextMapper.fromXml(contextMap);
            log.info((Object)("context map:\n" + this.contextMapper));
        }
        catch (DocumentException e) {
            throw new RuntimeException("unable to parse contextMap: " + contextMap, e);
        }
        String relClassJson = context.getConfiguration().get("relClasses");
        log.info((Object)("relClassesJson:\n" + relClassJson));
        this.relClasses = new RelClasses(relClassJson);
        log.info((Object)("relClasses:\n" + this.relClasses));
        String otherDsTypesUI = context.getConfiguration().get("ui.other.datasourcetypes");
        log.info((Object)("ui.other.datasourcetypes:" + otherDsTypesUI));
        this.otherDatasourceTypesUForUI = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)otherDsTypesUI));
        log.info((Object)("ui.other.datasourcetypes parsed:" + this.otherDatasourceTypesUForUI));
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        OafRowKeyDecoder keyDecoder = OafRowKeyDecoder.decode((String)key.toString());
        try {
            XmlRecordFactory builder = new XmlRecordFactory(this.entityConfigTable, this.contextMapper, this.relClasses, this.schemaLocation, true, false, false, this.otherDatasourceTypesUForUI);
            try {
                this.decodeValues(context, keyDecoder, values, builder);
                if (builder.isValid()) {
                    context.write((Object)keyDecoder.getKeyAsText(), (Object)new Text(builder.build()));
                } else {
                    context.getCounter("missing body (reduce)", keyDecoder.getType().toString()).increment(1L);
                }
            }
            catch (OutOfMemoryError e) {
                context.getCounter("error", e.getClass().getName()).increment(1L);
                log.error((Object)String.format("memory error building entity\nid: '%s'\ncounters: %s", keyDecoder.getKey(), builder.getRelCounters()), (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }

    private void decodeValues(Reducer.Context context, OafRowKeyDecoder keyDecoder, Iterable<ImmutableBytesWritable> values, XmlRecordFactory builder) {
        block4: for (ImmutableBytesWritable bytes : values) {
            OafDecoder decoder = OafHbaseUtils.decode(bytes);
            switch (decoder.getKind()) {
                case entity: {
                    builder.setMainEntity(decoder);
                    continue block4;
                }
                case relation: {
                    if (decoder.getOafRel().getChild()) {
                        builder.addChild(keyDecoder.getType(), decoder);
                        continue block4;
                    }
                    builder.addRelation(keyDecoder.getType(), decoder);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("unknow type: " + decoder.getKind());
        }
    }
}

