package eu.dnetlib.data.mapreduce.hbase.oai.config;

import java.util.List;

import eu.dnetlib.data.mapreduce.hbase.oai.utils.MDFInfo;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.PublisherField;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.SetInfo;

public interface OAIConfigurationReader {

	/**
	 * Constant names of fields used by the publisher to store records in the OAIStores. If you want an index over them, you need to specify
	 * it in the OAI Publisher Configuration profile.
	 */
	public final static String ID_FIELD = "objIdentifier";
	public final static String DATESTAMP_FIELD = "datestamp";
	public final static String SET_FIELD = "set";
	public final static String DELETED_FIELD = "deleted";
	public final static String BODY_FIELD = "body";
	public final static String UPDATED_FIELD = "updated";
	public final static String LAST_COLLECTION_DATE_FIELD = "lastCollectionDate";

	public List<SetInfo> getSets();

	public List<SetInfo> getSets(final boolean onlyEnabled);

	public List<String> getSetSpecs();

	public List<String> getSetSpecs(final boolean onlyEnabled);

	public SetInfo getSetInfo(final String setSpec);

	public List<MDFInfo> getMetadataFormatInfo();

	public List<MDFInfo> getMetadataFormatInfo(final boolean onlyEnabled);

	public MDFInfo getMetadataFormatInfo(final String mdPrefix);

	public List<String> getFieldNames();

	public List<PublisherField> getFields();

	public List<PublisherField> getFields(final String format, final String interpretation, final String layout);

	public List<MDFInfo> getSourceMetadataFormats();

}
