package eu.dnetlib.data.mapreduce;

/**
 * Created by claudio on 14/11/2016.
 */
public class Algorithms {

	public static double BASE_MIN = 0;

	public static double BASE_MAX = 1;

	public static double LIMIT_MIN = 0;

	/**

	 Source: https://stackoverflow.com/questions/5294955/how-to-scale-down-a-range-of-numbers-with-a-known-min-and-max-value

	 f(min) = a
	 f(max) = b

	 f(x) = x - min   ===>   f(min) = min - min = 0


        	 x - min                                  max - min
	 f(x) = ---------   ===>   f(min) = 0;  f(max) =  --------- = 1
	        max - min                                 max - min


	       (b-a)(x - min)
	f(x) = --------------  + a
	          max - min
	 */
	public static double scale(final double valueIn, final double baseMin, final double baseMax, final double limitMin, final double limitMax) {
		return ((limitMax - limitMin) * (valueIn - baseMin) / (baseMax - baseMin)) + limitMin;
	}

	public static double scale(final double valueIn, final double limitMin, final double limitMax) {
		return scale(valueIn, BASE_MIN, BASE_MAX, limitMin, limitMax);
	}

	public static double scale(final double valueIn, final double limitMax) {
		return scale(valueIn, BASE_MIN, BASE_MAX, LIMIT_MIN, limitMax);
	}

}
