/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupSimilarityToHdfsActionsMapper
extends TableMapper<Text, Text> {
    private static final Log log = LogFactory.getLog(DedupSimilarityToHdfsActionsMapper.class);
    private static final String RAW_SET = "rawSetId";
    private static final String SIMILARITY_CF = "similarityCF";
    private String rawSet = null;
    private String similarityCF = null;
    private DedupConfig dedupConf = null;
    private ActionFactory actionFactory = null;
    private Text keyOut;
    private Text valueOut;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.rawSet = context.getConfiguration().get(RAW_SET);
        if (StringUtils.isBlank((String)this.rawSet)) {
            throw new IOException("Input parameter (rawSetId) is missing or empty: '" + this.rawSet + "'");
        }
        log.info((Object)("raw set: '" + this.rawSet + "'"));
        this.similarityCF = context.getConfiguration().get(SIMILARITY_CF);
        if (StringUtils.isBlank((String)this.similarityCF)) {
            throw new IOException("Input parameter (similarityCF) is missing or empty: '" + this.similarityCF + "'");
        }
        log.info((Object)("similarityCF: '" + this.similarityCF + "'"));
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        log.info((Object)("wf conf: " + this.dedupConf.toString()));
        this.actionFactory = new ActionFactory();
        this.keyOut = new Text();
        this.valueOut = new Text();
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        NavigableMap sMap = value.getFamilyMap(Bytes.toBytes((String)this.similarityCF));
        if (MapUtils.isEmpty((Map)sMap)) {
            return;
        }
        Agent agent = new Agent("dedup", "Deduplication", Agent.AGENT_TYPE.algo);
        for (Map.Entry similarity : sMap.entrySet()) {
            String targetKey = new String(key.copyBytes());
            String qualifier = new String((byte[])similarity.getKey());
            AtomicAction aa = this.actionFactory.createAtomicAction(this.rawSet, agent, targetKey, this.similarityCF, qualifier, null);
            this.keyOut.set(aa.getTargetRowKey() + "@" + aa.getTargetColumnFamily() + "@" + aa.getTargetColumn());
            this.valueOut.set(aa.toJSON());
            context.write((Object)this.keyOut, (Object)this.valueOut);
            context.getCounter(this.dedupConf.getWf().getEntityType(), "similarity2actions").increment(1L);
        }
    }
}

