/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.hbase.dataimport.ScholExplorerConfiguration;
import eu.dnetlib.data.mapreduce.hbase.dataimport.ScholixToActions;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class ScholexplorerMapper
extends Mapper<LongWritable, Text, Text, Text> {
    private ActionFactory factory;
    private JsonParser parser;
    private String setName;
    private Agent agent;
    private String nsPrefix;
    private String dsName;
    private String dsId;
    private String dateOfCollection;
    private Text keyout;
    private Text valueOut;
    private Map<String, ScholExplorerConfiguration> conf = new HashMap<String, ScholExplorerConfiguration>();

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.factory = new ActionFactory();
        this.parser = new JsonParser();
        this.conf.put("issn", new ScholExplorerConfiguration(null, false));
        this.conf.put("pmid", new ScholExplorerConfiguration("pmid", true, "https://www.ncbi.nlm.nih.gov/pubmed/%s"));
        this.conf.put("doi", new ScholExplorerConfiguration("doi", true, "http://dx.doi.org/%s"));
        this.conf.put("pbmid", new ScholExplorerConfiguration("pmid", true, "https://www.ncbi.nlm.nih.gov/pubmed/%s"));
        this.conf.put("openaire", new ScholExplorerConfiguration(null, false));
        this.conf.put("pmcid", new ScholExplorerConfiguration("pmc", true, "https://europepmc.org/articles/%s"));
        this.conf.put("pubmedid", new ScholExplorerConfiguration("pmid", true, "https://www.ncbi.nlm.nih.gov/pubmed/%s"));
        this.conf.put("icpsr", new ScholExplorerConfiguration(null, false));
        this.conf.put("dnet", new ScholExplorerConfiguration(null, false));
        this.conf.put("url", new ScholExplorerConfiguration(null, true, "%s"));
        this.setName = context.getConfiguration().get("setName");
        this.agent = new Agent(context.getConfiguration().get("agentId"), context.getConfiguration().get("agentName"), Agent.AGENT_TYPE.service);
        this.nsPrefix = context.getConfiguration().get("ns_prefix");
        this.dsName = context.getConfiguration().get("dsName");
        this.dsId = context.getConfiguration().get("dsId");
        this.dateOfCollection = context.getConfiguration().get("dateOfCollection", DateUtils.now_ISO8601());
        this.keyout = new Text("");
        this.valueOut = new Text("");
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String inputJson = value.toString();
        JsonObject rootElement = this.parser.parse(inputJson).getAsJsonObject();
        try {
            List<AtomicAction> actions = ScholixToActions.generateActionsFromScholix(rootElement, this.conf, this.setName, this.agent, this.factory, this.nsPrefix, this.dsName, this.dsId, this.dateOfCollection);
            for (AtomicAction action : actions) {
                this.keyout.set(action.getRowKey());
                this.valueOut.set(action.toJSON());
                context.write((Object)this.keyout, (Object)this.valueOut);
            }
        }
        catch (Throwable e) {
            System.err.println(inputJson);
            throw e;
        }
    }
}

