/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.bulktag;

import com.google.common.collect.Maps;
import eu.dnetlib.data.bulktag.CommunityConfiguration;
import eu.dnetlib.data.bulktag.Pair;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.mapreduce.Mapper;

public class ResultTagger {
    private static final String DATA_INFO_TYPE = "bulktagging::community";
    private static final String SCHEMA_NAME = "dnet:provenanceActions";
    private static final String CLASS_ID = "bulktagging::community";
    private static final String SCHEMA_ID = "dnet:provenanceActions";
    private static final String COUNTER_GROUP = "Bulk Tagging";

    public OafProtos.Oaf enrichContext(OafProtos.Oaf oaf, CommunityConfiguration conf, Mapper.Context context) {
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)oaf);
        if (oaf.getDataInfo().getDeletedbyinference()) {
            context.getCounter(COUNTER_GROUP, "deleted by inference").increment(1L);
            return null;
        }
        List contextList = oaf.getEntity().getResult().getMetadata().getContextList();
        if (contextList.size() > 0) {
            context.getCounter(COUNTER_GROUP, "exist context list").increment(1L);
        } else {
            context.getCounter(COUNTER_GROUP, "not exist context list").increment(1L);
        }
        HashSet communities = new HashSet();
        oaf.getEntity().getResult().getMetadata().getSubjectList().stream().map(subject -> subject.getValue()).filter(StringUtils::isNotBlank).map(String::toLowerCase).map(String::trim).collect(Collectors.toCollection(HashSet::new)).forEach(s -> communities.addAll(conf.getCommunityForSubjectValue(s)));
        oaf.getEntity().getResult().getInstanceList().stream().map(i -> new Pair((Object)i.getCollectedfrom().getKey(), (Object)i.getHostedby().getKey())).flatMap(p -> Stream.of((String)p.getFst(), (String)p.getSnd())).map(s -> StringUtils.substringAfter((String)s, (String)"|")).collect(Collectors.toCollection(HashSet::new)).forEach(dsId -> communities.addAll(conf.getCommunityForDatasourceValue(dsId)));
        if (communities.isEmpty()) {
            context.getCounter(COUNTER_GROUP, "list of communities empty").increment(1L);
        } else {
            context.getCounter(COUNTER_GROUP, "list of communities has values!").increment(1L);
        }
        ResultProtos.Result.Metadata.Builder mBuilder = builder.getEntityBuilder().getResultBuilder().getMetadataBuilder();
        HashMap cBuilders = Maps.newHashMap();
        mBuilder.getContextBuilderList().forEach(cBuilder -> cBuilders.put(cBuilder.getId(), cBuilder));
        for (String contextId : communities) {
            ResultProtos.Result.Context.Builder cBuilder2 = (ResultProtos.Result.Context.Builder)cBuilders.get(contextId);
            if (cBuilder2 != null) {
                if (!cBuilder2.getDataInfoBuilderList().stream().map(di -> di.getInferenceprovenance()).anyMatch(s -> "bulktagging::community".equals(s))) {
                    cBuilder2.addDataInfo(this.buildDataInfo());
                    context.getCounter(COUNTER_GROUP, "add provenance").increment(1L);
                    continue;
                }
                context.getCounter(COUNTER_GROUP, "provenance already bulk tagged").increment(1L);
                continue;
            }
            context.getCounter(COUNTER_GROUP, "add context").increment(1L);
            mBuilder.addContext(this.buildContext(contextId));
        }
        return builder.build();
    }

    private ResultProtos.Result.Context buildContext(String contextId) {
        return ResultProtos.Result.Context.newBuilder().setId(contextId).addDataInfo(this.buildDataInfo()).build();
    }

    private FieldTypeProtos.DataInfo buildDataInfo() {
        FieldTypeProtos.DataInfo.Builder builder = FieldTypeProtos.DataInfo.newBuilder().setInferred(true).setProvenanceaction(FieldTypeProtos.Qualifier.newBuilder().setClassid("bulktagging::community").setClassname("Bulk Tagging for Communities").setSchemeid("dnet:provenanceActions").setSchemename("dnet:provenanceActions")).setInferenceprovenance("bulktagging::community").setTrust("0.85");
        return builder.build();
    }
}

