/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.hbase.dataimport.DumpToActionsUtility;
import eu.dnetlib.data.mapreduce.util.StreamUtils;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CrossRefToActions {
    public static AtomicAction generateActionsFromDump(JsonObject rootElement, ActionFactory factory, String setName, Agent agent, boolean invisible) {
        String publisher;
        OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder();
        oaf.setDataInfo(FieldTypeProtos.DataInfo.newBuilder().setInvisible(invisible).setDeletedbyinference(false).setInferred(false).setTrust("0.9").setProvenanceaction(DumpToActionsUtility.getQualifier("sysimport:actionset", "dnet:provenanceActions")).build());
        oaf.setKind(KindProtos.Kind.entity);
        OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result);
        entity.setDateofcollection(Objects.requireNonNull(DumpToActionsUtility.getStringValue(rootElement, "dateOfCollection")));
        if (rootElement.has("collectedFrom") && rootElement.get("collectedFrom").isJsonArray()) {
            StreamUtils.toStream(rootElement.getAsJsonArray("collectedFrom").iterator()).map(JsonElement::getAsJsonObject).forEach(cf -> {
                String id = DumpToActionsUtility.getStringValue(cf, "id");
                String name = DumpToActionsUtility.getStringValue(cf, "name");
                if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)name)) {
                    FieldTypeProtos.KeyValue collectedFrom = FieldTypeProtos.KeyValue.newBuilder().setValue(name).setKey("10|openaire____::" + AbstractDNetXsltFunctions.md5((String)StringUtils.substringAfter((String)id, (String)"::"))).build();
                    entity.addCollectedfrom(collectedFrom);
                }
            });
        }
        String objIdentifier = DumpToActionsUtility.getStringValue(rootElement, "objIdentifier");
        String nsPrefix = DumpToActionsUtility.getStringValue(rootElement, "datasourcePrefix");
        if (StringUtils.isBlank((CharSequence)objIdentifier)) {
            return null;
        }
        String sourceId = String.format("50|%s::%s", nsPrefix, objIdentifier);
        entity.setId(sourceId);
        String doi = DumpToActionsUtility.getStringValue(rootElement, "doi");
        if (doi == null) {
            return null;
        }
        entity.addPid(FieldTypeProtos.StructuredProperty.newBuilder().setValue(doi).setQualifier(DumpToActionsUtility.getQualifier("doi", "dnet:pid_types")).build());
        ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder();
        String typeValue = DumpToActionsUtility.getStringValue(rootElement.getAsJsonObject("type"), "value");
        String cobjValue = DumpToActionsUtility.getStringValue(rootElement.getAsJsonObject("type"), "cobj");
        String best_oa_location_url = DumpToActionsUtility.getStringValue(rootElement, "best_oa_location_url");
        ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder();
        instance.setInstancetype(FieldTypeProtos.Qualifier.newBuilder().setClassid(cobjValue).setClassname(typeValue).setSchemeid("dnet:publication_resource").setSchemename("dnet:publication_resource").build());
        instance.setHostedby(FieldTypeProtos.KeyValue.newBuilder().setKey("10|openaire____::55045bd2a65019fd8e6741a755395c8c").setValue("Unknown Repository").build());
        if (StringUtils.isNotBlank((CharSequence)best_oa_location_url)) {
            instance.addUrl(best_oa_location_url);
            instance.setAccessright(FieldTypeProtos.Qualifier.newBuilder().setClassid("OPEN").setClassname("open access").setSchemeid("dnet:access_modes").setSchemename("dnet:access_modes").build());
            instance.setCollectedfrom(FieldTypeProtos.KeyValue.newBuilder().setValue("UnpayWall").setKey("10|openaire____::" + AbstractDNetXsltFunctions.md5((String)"unpaywall")).build());
        } else {
            instance = ResultProtos.Result.Instance.newBuilder();
            instance.addUrl(String.format("http://dx.doi.org/%s", doi));
            instance.setAccessright(FieldTypeProtos.Qualifier.newBuilder().setClassid("CLOSED").setClassname("Closed Access").setSchemeid("dnet:access_modes").setSchemename("dnet:access_modes").build());
            instance.setCollectedfrom(FieldTypeProtos.KeyValue.newBuilder().setValue("CrossRef").setKey("10|openaire____::" + AbstractDNetXsltFunctions.md5((String)"crossref")).build());
        }
        result.addInstance(instance.build());
        ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
        List<FieldTypeProtos.Author> authors = CrossRefToActions.createAuthors(rootElement);
        if (authors != null) {
            metadata.addAllAuthor(authors);
        }
        metadata.setLanguage(FieldTypeProtos.Qualifier.newBuilder().setClassid("und").setClassname("Undetermined").setSchemeid("dent:languages").setSchemename("dent:languages").build());
        List<String> subjects = DumpToActionsUtility.getArrayValues(rootElement, "subject");
        subjects.forEach(s -> metadata.addSubject(FieldTypeProtos.StructuredProperty.newBuilder().setValue(s).setQualifier(DumpToActionsUtility.getQualifier("keyword", "dnet:subject")).build()));
        List<String> titles = DumpToActionsUtility.getArrayValues(rootElement, "title");
        titles.forEach(t -> metadata.addTitle(FieldTypeProtos.StructuredProperty.newBuilder().setValue(t).setQualifier(DumpToActionsUtility.getQualifier("main title", "dnet:dataCite_title")).build()));
        String date = DumpToActionsUtility.getStringValue(rootElement, "issued");
        if (date.length() == 4) {
            date = date + "-01-01";
        }
        if (DumpToActionsUtility.isValidDate(date)) {
            metadata.setDateofacceptance(FieldTypeProtos.StringField.newBuilder().setValue(date).build());
        }
        String description = null;
        if (rootElement.has("abstract") && rootElement.get("abstract").isJsonArray()) {
            description = String.join((CharSequence)" ", DumpToActionsUtility.getArrayValues(rootElement, "abstract"));
        } else if (rootElement.has("abstract")) {
            description = rootElement.get("abstract").getAsString();
        }
        if (StringUtils.isNotBlank(description)) {
            metadata.addDescription(FieldTypeProtos.StringField.newBuilder().setValue(description).build());
        }
        if (StringUtils.isNotBlank((CharSequence)(publisher = DumpToActionsUtility.getStringValue(rootElement, "publisher")))) {
            ResultProtos.Result.Journal.Builder journal = ResultProtos.Result.Journal.newBuilder().setName(publisher);
            if (CrossRefToActions.hasJSONArrayField(rootElement, "issn")) {
                StreamUtils.toStream(rootElement.getAsJsonArray("issn").iterator()).map(JsonElement::getAsJsonObject).forEach(it -> {
                    String type = DumpToActionsUtility.getStringValue(it, "type");
                    String value = DumpToActionsUtility.getStringValue(it, "value");
                    if ("electronic".equals(type)) {
                        journal.setIssnOnline(value);
                    }
                    if ("print".equals(type)) {
                        journal.setIssnPrinted(value);
                    }
                });
            }
            metadata.setJournal(journal.build());
        }
        metadata.setResulttype(DumpToActionsUtility.getQualifier(DumpToActionsUtility.getDefaultResulttype(cobjValue), "dnet:result_typologies"));
        result.setMetadata(metadata.build());
        entity.setResult(result.build());
        oaf.setEntity(entity.build());
        return factory.createAtomicAction(setName, agent, oaf.getEntity().getId(), "result", "body", oaf.build().toByteArray());
    }

    private static boolean hasJSONArrayField(JsonObject root, String key) {
        return root.has(key) && root.get(key).isJsonArray();
    }

    public static List<FieldTypeProtos.Author> createAuthors(JsonObject root) {
        if (root.has("author") && root.get("author").isJsonArray()) {
            ArrayList<FieldTypeProtos.Author> authors = new ArrayList<FieldTypeProtos.Author>();
            JsonArray jsonAuthors = root.getAsJsonArray("author");
            int i = 0;
            for (JsonElement item : jsonAuthors) {
                JsonObject author = item.getAsJsonObject();
                FieldTypeProtos.Author.Builder result = FieldTypeProtos.Author.newBuilder();
                String given = DumpToActionsUtility.getStringValue(author, "given");
                String family = DumpToActionsUtility.getStringValue(author, "family");
                String orchid = DumpToActionsUtility.getStringValue(author, "ORCID");
                if (StringUtils.isBlank((CharSequence)given) && StringUtils.isBlank((CharSequence)family)) continue;
                result.setFullname(given + " " + family);
                if (StringUtils.isNotBlank((CharSequence)given)) {
                    result.setName(given);
                }
                if (StringUtils.isNotBlank((CharSequence)family)) {
                    result.setSurname(family);
                }
                if (StringUtils.isNotBlank((CharSequence)orchid)) {
                    result.addPid(FieldTypeProtos.KeyValue.newBuilder().setValue(orchid).setKey("ORCID").build());
                }
                result.setRank(i++);
                authors.add(result.build());
            }
            return authors;
        }
        return null;
    }
}

