package eu.dnetlib.data.mapreduce.hbase.dataexport;

import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.util.StreamUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

import java.io.IOException;
import java.io.StringReader;

/**
 * Exports the result identifiers as json.
 *
 * @author claudio
 */
public class ExportSubjectsReducer extends Reducer<Text, Text, Text, Text> {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(ExportSubjectsReducer.class); // NOPMD by marko on 11/24/08 5:02 PM

	private Text keyOut = new Text("");
	private Text valueOut = new Text("");

	@Override
	protected void setup(final Context context) throws IOException, InterruptedException {
		super.setup(context);
	}

	@Override
	protected void reduce(final Text keyIn, final Iterable<Text> values, final Context context) throws IOException, InterruptedException {
		try {

			final Subject s = new Gson().fromJson(new StringReader(keyIn.toString()), Subject.class);

			long count = StreamUtils.toStream(values.iterator()).count();

			s.setCount(count);

			valueOut.set(s.toJson());

			context.write(keyOut, valueOut);

		} catch (final Throwable e) {
			//log.error("error exporting the following record from HBase: " + value.toString(), e);
			context.getCounter("error", e.getClass().getName()).increment(1);
			throw new RuntimeException(e);
		}
	}

}
