/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import eu.dnetlib.data.mapreduce.hbase.broker.AbstractEventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.OAVersionEventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.PIDEventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.PublicationDateEventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.SubjectEventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.enrich.AbstractEnrichmentReducer;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class EnrichmentReducer
extends AbstractEnrichmentReducer {
    @Override
    protected String counterGroup() {
        return "Broker Enrichment";
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        try {
            this.generateEvents(Streams.stream(values).limit(1000L).map(AbstractEnrichmentReducer::toOaf).collect(Collectors.toList()), context);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateEvents(List<OafProtos.Oaf> oafList, Reducer.Context context) throws IOException, InterruptedException, DocumentException {
        for (OafProtos.Oaf current : oafList) {
            context.getCounter(this.counterGroup(), "entity type: " + current.getEntity().getResult().getMetadata().getResulttype().getClassid()).increment(1L);
            String currentId = current.getEntity().getId();
            String currentDsId = StringUtils.substringAfter((String)OafHbaseUtils.getKey(current.getEntity().getCollectedfromList()), (String)"|");
            String currentDsType = (String)this.dsTypeMap.get(currentDsId);
            if (StringUtils.isBlank((String)currentDsType) && !this.dsWhitelist.contains(currentDsId)) {
                context.getCounter("events skipped", "datasource type excluded").increment(1L);
                continue;
            }
            if (this.dsBlacklist.contains(currentDsId)) {
                context.getCounter("events skipped", "datasource blacklisted").increment(1L);
                continue;
            }
            ArrayList events = Lists.newArrayList();
            for (OafProtos.Oaf other : oafList) {
                String otherId = other.getEntity().getId();
                if (!currentId.equals(otherId)) {
                    double similarity = this.similarity(current, other);
                    if (similarity >= this.dedupConf.getWf().getThreshold()) {
                        float trust = this.scale(similarity);
                        if (!DedupUtils.isRoot(currentId) && !DedupUtils.isRoot(otherId)) {
                            events.addAll(PIDEventFactory.process(current, other, trust));
                            events.addAll(OAVersionEventFactory.process(current, other, trust, this.untrustedOaDsList));
                            events.addAll(AbstractEventFactory.process(current, other, trust));
                            events.addAll(PublicationDateEventFactory.process(current, other, trust));
                        }
                        events.addAll(SubjectEventFactory.process(context, current, other, trust));
                        continue;
                    }
                    context.getCounter(this.counterGroup(), "d < " + this.dedupConf.getWf().getThreshold()).increment(1L);
                    continue;
                }
                if (oafList.size() != 1) continue;
                events.addAll(SubjectEventFactory.process(context, current));
            }
            this.emit(events, context);
        }
    }
}

