/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.model;

import eu.dnetlib.data.mapreduce.hbase.broker.model.Event;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.mapreduce.hbase.broker.model.MapValue;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

public class EventWrapper {
    private final EventMessage event;
    private final String counterName;
    private final String highlightValue;

    public static EventWrapper newInstance(EventMessage event, String highlightValue, String counterName) {
        return new EventWrapper(event, highlightValue, counterName);
    }

    public EventWrapper(EventMessage event, String highlightValue, String counterName) {
        this.event = event;
        this.counterName = counterName;
        this.highlightValue = highlightValue;
    }

    public Event asBrokerEvent() {
        Date now = new Date();
        Event res = new Event();
        String eventId = this.calculateEventId(this.event.getTopic(), this.event.getMap().get("target_publication_id").toString(), this.highlightValue);
        res.setEventId(eventId);
        res.setProducerId(this.event.getProducerId());
        res.setPayload(this.event.getPayload());
        res.setMap(this.event.getMap().entrySet().stream().filter(e -> ((MapValue)e.getValue()).asObject() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((MapValue)e.getValue()).asObject())));
        res.setTopic(this.event.getTopic());
        res.setCreationDate(now);
        res.setExpiryDate(this.calculateExpiryDate(now, this.event.getTthDays()));
        res.setInstantMessage(this.event.getTthDays() == 0);
        return res;
    }

    private String calculateEventId(String topic, String publicationId, String value) {
        return "event-" + DigestUtils.md5Hex((String)topic).substring(0, 6) + "-" + DigestUtils.md5Hex((String)publicationId).substring(0, 8) + "-" + DigestUtils.md5Hex((String)value).substring(0, 8);
    }

    private Date calculateExpiryDate(Date now, int ttlDays) {
        if (ttlDays < 0) {
            return null;
        }
        if (ttlDays == 0) {
            return now;
        }
        return new Date(now.getTime() + (long)(ttlDays * 24 * 60 * 60 * 1000));
    }

    public EventMessage getEvent() {
        return this.event;
    }

    public String getCounterName() {
        return this.counterName;
    }
}

