/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.oai;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import eu.dnetlib.data.mapreduce.hbase.oai.config.OAIConfiguration;
import eu.dnetlib.data.mapreduce.hbase.oai.config.OAIConfigurationStringReader;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.MongoSetCollection;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.PublisherField;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.RecordFieldsExtractor;
import eu.dnetlib.miscutils.functional.xml.IndentXmlString;
import java.io.IOException;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.bson.types.Binary;

public class OaiFeedMapper
extends Mapper<Text, Text, NullWritable, NullWritable> {
    private MongoCollection<DBObject> collection;
    private MongoCollection<DBObject> discardedCollection;
    private OAIConfigurationStringReader oaiConfigurationReader;
    private OAIConfiguration oaiConfiguration;
    private Date feedDate;
    private MongoSetCollection mongoSetCollection;
    private RecordFieldsExtractor extractor;
    private String format;
    private String interpretation;
    private String layout;
    private Map<String, PublisherField> fieldsToIndex = Maps.newHashMap();
    private String duplicateXPath;
    private boolean skipDuplicates;
    private MongoClient mongo;
    private Collection<String> enrichmentXPaths;
    private String[] parseDatePatterns;

    protected void setup(Mapper.Context context) throws UnknownHostException {
        String host = context.getConfiguration().get("services.publisher.oai.host");
        String port = context.getConfiguration().get("services.publisher.oai.port");
        String db = context.getConfiguration().get("services.publisher.oai.db");
        String collectionName = context.getConfiguration().get("services.publisher.oai.collection");
        String patterns = context.getConfiguration().get("services.publisher.oai.datepatterns");
        this.parseDatePatterns = Lists.newArrayList((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)patterns)).toArray(new String[0]);
        System.out.println("Mongodb client params");
        System.out.println("host: " + host);
        System.out.println("port: " + port);
        System.out.println("db: " + db);
        System.out.println("collection: " + collectionName);
        System.out.println("split date patterns: " + patterns);
        String[] formatLayoutInterp = collectionName.split("-");
        this.format = formatLayoutInterp[0];
        this.layout = formatLayoutInterp[1];
        this.interpretation = formatLayoutInterp[2];
        String oaiConfigurationProfile = context.getConfiguration().get("oaiConfiguration");
        System.out.println("oaiConfiguration:\n" + IndentXmlString.apply((String)oaiConfigurationProfile));
        this.oaiConfigurationReader = new OAIConfigurationStringReader(oaiConfigurationProfile);
        this.oaiConfiguration = this.oaiConfigurationReader.getOaiConfiguration();
        System.out.println("parsed configuration:" + this.oaiConfiguration.toString());
        this.mongo = new MongoClient(host, Integer.parseInt(port));
        MongoDatabase mongoDB = this.mongo.getDatabase(db);
        this.collection = mongoDB.getCollection(collectionName, DBObject.class).withWriteConcern(WriteConcern.UNACKNOWLEDGED);
        this.discardedCollection = mongoDB.getCollection("discarded-" + collectionName, DBObject.class).withWriteConcern(WriteConcern.UNACKNOWLEDGED);
        this.mongoSetCollection = new MongoSetCollection(this.mongo);
        this.duplicateXPath = context.getConfiguration().get("services.publisher.oai.duplicateXPath");
        this.skipDuplicates = Boolean.parseBoolean(context.getConfiguration().get("services.publisher.oai.skipDuplicates"));
        this.enrichmentXPaths = this.oaiConfiguration.getEnrichmentXPathsFor(this.format, this.layout, this.interpretation);
        Collection<PublisherField> indexFields = this.oaiConfiguration.getFieldsFor(this.format, this.layout, this.interpretation);
        this.extractor = new RecordFieldsExtractor(Lists.newArrayList(indexFields));
        this.extractor.setDuplicateXPath(this.duplicateXPath);
        this.extractor.setSkipDuplicates(this.skipDuplicates);
        for (PublisherField field : indexFields) {
            this.fieldsToIndex.put(field.getFieldName(), field);
        }
        String feedDateString = context.getConfiguration().get("oai.feed.date");
        this.feedDate = this.parseDate(feedDateString);
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String recordKey = key.toString();
        String recordBody = value.toString();
        if (StringUtils.isBlank((String)recordBody)) {
            this.discard(context, recordKey, recordBody, "blank body");
        } else {
            Multimap<String, String> recordFields = this.extractor.extractFields(recordBody, this.enrichmentXPaths);
            if (this.checkRecordFields(recordFields, context, recordKey, recordBody)) {
                String id = (String)recordFields.get((Object)"objIdentifier").iterator().next();
                String oaiID = this.getOAIIdentifier(id);
                this.handleRecord(context, oaiID, recordBody, recordFields);
            }
        }
    }

    public boolean checkRecordFields(Multimap<String, String> recordFields, Mapper.Context context, String recordKey, String recordBody) {
        if (recordFields == null) {
            context.getCounter("oai", "invalid").increment(1L);
            return false;
        }
        if (recordFields.containsEntry((Object)"duplicate", (Object)"true")) {
            if (this.skipDuplicates) {
                context.getCounter("oai", "discardedDuplicate").increment(1L);
                return false;
            }
            return true;
        }
        if (!recordFields.containsKey((Object)"objIdentifier")) {
            this.discard(context, recordKey, recordBody, "missing objIdentifier");
            return false;
        }
        return true;
    }

    private void handleRecord(Mapper.Context context, String oaiID, String record, Multimap<String, String> recordProperties) {
        DBObject obj = this.createBasicObject(oaiID, record, recordProperties, context);
        if (obj != null) {
            Collection collectionDates = recordProperties.get((Object)"dateOfCollection");
            Collection transDates = recordProperties.get((Object)"dateOfTransformation");
            Date collDate = this.feedDate;
            if (collectionDates != null && !collectionDates.isEmpty()) {
                String collDateString = (String)collectionDates.iterator().next();
                if (StringUtils.isNotBlank((String)collDateString)) {
                    collDate = this.parseDate(collDateString);
                }
            } else {
                context.getCounter("oai", "missing dateOfCollection").increment(1L);
            }
            obj.put("lastCollectionDate", (Object)collDate);
            Date timestamp = this.feedDate;
            if (transDates != null && !transDates.isEmpty()) {
                String transDateString = (String)transDates.iterator().next();
                if (StringUtils.isNotBlank((String)transDateString)) {
                    timestamp = this.parseDate(transDateString);
                }
            } else {
                context.getCounter("oai", "missing dateOfTransformation").increment(1L);
            }
            obj.put("datestamp", (Object)timestamp);
            obj.put("updated", (Object)false);
            this.collection.insertOne((Object)obj);
            context.getCounter("oai", "total").increment(1L);
        }
    }

    protected Date parseDate(String date) {
        try {
            LocalDateTime d = LocalDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            return Date.from(d.atZone(ZoneId.systemDefault()).toInstant());
        }
        catch (Exception dateException) {
            try {
                return DateUtils.parseDate((String)date, (String[])this.parseDatePatterns);
            }
            catch (Exception dateException2) {
                dateException2.printStackTrace(System.err);
                throw new RuntimeException(dateException2);
            }
        }
    }

    private void discard(Mapper.Context context, String recordKey, String recordBody, String reason) {
        context.getCounter("oai", reason).increment(1L);
        this.discardedCollection.insertOne((Object)new BasicDBObject("id", (Object)recordKey).append("body", (Object)recordBody));
    }

    private String getOAIIdentifier(String id) {
        return this.oaiConfiguration.getIdScheme() + ":" + this.oaiConfiguration.getIdNamespace() + ":" + id;
    }

    protected DBObject createBasicObject(String oaiID, String record, Multimap<String, String> recordProperties, Mapper.Context context) {
        BasicDBObject obj = new BasicDBObject();
        for (String key : recordProperties.keySet()) {
            if (key.equals("objIdentifier")) {
                obj.put(key, (Object)oaiID);
                continue;
            }
            Collection values = recordProperties.get((Object)key);
            if (key.equals("set")) {
                Iterable setSpecs = Iterables.transform((Iterable)values, s -> this.mongoSetCollection.normalizeSetSpec((String)s));
                obj.put(key, (Object)setSpecs);
                continue;
            }
            PublisherField keyField = this.fieldsToIndex.get(key);
            if (keyField == null) continue;
            if (keyField != null && !keyField.isRepeatable()) {
                if (values == null || values.isEmpty()) continue;
                obj.put(key, values.iterator().next());
                continue;
            }
            obj.put(key, (Object)values);
        }
        Binary compressedRecordBody = this.createCompressRecord(context, oaiID, record);
        if (compressedRecordBody != null) {
            obj.put("body", (Object)compressedRecordBody);
            obj.put("deleted", (Object)false);
            return obj;
        }
        return null;
    }

    public Binary createCompressRecord(Mapper.Context context, String recordKey, String recordBody) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream((OutputStream)os);
            ZipEntry entry = new ZipEntry("body");
            zos.putNextEntry(entry);
            zos.write(recordBody.getBytes());
            zos.closeEntry();
            zos.flush();
            zos.close();
            return new Binary(os.toByteArray());
        }
        catch (IOException e) {
            this.discard(context, recordKey, recordBody, "cannot compress");
            return null;
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
    }

    public MongoCollection<DBObject> getCollection() {
        return this.collection;
    }

    public void setCollection(MongoCollection<DBObject> collection) {
        this.collection = collection;
    }

    public MongoCollection<DBObject> getDiscardedCollection() {
        return this.discardedCollection;
    }

    public void setDiscardedCollection(MongoCollection<DBObject> discardedCollection) {
        this.discardedCollection = discardedCollection;
    }

    public OAIConfigurationStringReader getOaiConfigurationReader() {
        return this.oaiConfigurationReader;
    }

    public void setOaiConfigurationReader(OAIConfigurationStringReader oaiConfigurationReader) {
        this.oaiConfigurationReader = oaiConfigurationReader;
    }

    public OAIConfiguration getOaiConfiguration() {
        return this.oaiConfiguration;
    }

    public void setOaiConfiguration(OAIConfiguration oaiConfiguration) {
        this.oaiConfiguration = oaiConfiguration;
    }

    public Date getFeedDate() {
        return this.feedDate;
    }

    public void setFeedDate(Date feedDate) {
        this.feedDate = feedDate;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }

    public String getDuplicateXPath() {
        return this.duplicateXPath;
    }

    public void setDuplicateXPath(String duplicateXPath) {
        this.duplicateXPath = duplicateXPath;
    }

    public boolean isSkipDuplicates() {
        return this.skipDuplicates;
    }

    public void setSkipDuplicates(boolean skipDuplicates) {
        this.skipDuplicates = skipDuplicates;
    }

    public String[] getParseDatePatterns() {
        return this.parseDatePatterns;
    }

    public void setParseDatePatterns(String[] parseDatePatterns) {
        this.parseDatePatterns = parseDatePatterns;
    }

    static enum RecordStatus {
        NEW,
        UPDATED,
        UNCHANGED;

    }
}

