package eu.dnetlib.data.mapreduce.hbase.broker.model;

import java.util.Map;

import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;

/**
 * Created by claudio on 08/07/16.
 */
public class EventMessage {

	public static final int TTH_INFINITE = -1;

	private String producerId;
	private String topic;
	private String payload;
	private int tthDays = TTH_INFINITE;
	private Map<String, MapValue> map;

	public EventMessage() {}

	public EventMessage(final String producerId, final Topic topic, final String payload, final int tthDays, final Map<String, MapValue> map) {
		this.producerId = producerId;
		this.topic = topic.getValue();
		this.payload = payload;
		this.tthDays = tthDays;
		this.map = map;
	}

	public String getProducerId() {
		return this.producerId;
	}

	public void setProducerId(final String producerId) {
		this.producerId = producerId;
	}

	public String getTopic() {
		return this.topic;
	}

	public void setTopic(final String topic) {
		this.topic = topic;
	}

	public String getPayload() {
		return this.payload;
	}

	public void setPayload(final String payload) {
		this.payload = payload;
	}

	public Map<String, MapValue> getMap() {
		return this.map;
	}

	public void setMap(final Map<String, MapValue> map) {
		this.map = map;
	}

	public boolean hasNulls() {
		return (this.producerId == null) || (this.topic == null) || (this.payload == null) || (this.map == null);
	}

	public int getTthDays() {
		return this.tthDays;
	}

	public void setTthDays(final int tthDays) {
		this.tthDays = tthDays;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}
}
