package eu.dnetlib.data.mapreduce.hbase.dataexport;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;

import java.io.IOException;

/**
 * Exports the result identifiers as json.
 *
 * @author claudio
 */
public class ExportSubjectsMapper extends TableMapper<Text, Text> {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(ExportSubjectsMapper.class); // NOPMD by marko on 11/24/08 5:02 PM

	private static final String CF = "result";

	private Text keyOut;

	private Text one;

	@Override
	protected void setup(final Context context) throws IOException, InterruptedException {
		super.setup(context);

		keyOut = new Text("");
		one = new Text("1");
	}

	@Override
	protected void map(final ImmutableBytesWritable keyIn, final Result value, final Context context) throws IOException, InterruptedException {
		try {
			final byte[] body = value.getValue(Bytes.toBytes(CF), DedupUtils.BODY_B);

			if (body == null) {
				context.getCounter(CF, "missing body").increment(1);
				return;
			}

			final OafProtos.Oaf d = OafDecoder.decode(body).getOaf();

			if (d.getDataInfo().getDeletedbyinference()) {
				context.getCounter(CF, "deleted by inference").increment(1);
				return;
			}

			ResultProtos.Result.Metadata m = d.getEntity().getResult().getMetadata();
			if (m.getSubjectCount() > 0) {

				m.getSubjectList().stream()
						.map(s -> new Subject(s.getQualifier().getClassid(), s.getValue()))
						.forEach(s -> {
							keyOut.set(s.toJson());
							try {
								context.write(keyOut, one);
							} catch (IOException | InterruptedException e) {
								e.printStackTrace();
							}
						});
			}

		} catch (final Throwable e) {
			log.error("error exporting the following record from HBase: " + value.toString(), e);
			context.getCounter("error", e.getClass().getName()).increment(1);
			throw new RuntimeException(e);
		}
	}

}
