/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataexport;

import eu.dnetlib.data.mapreduce.hbase.dataexport.Subject;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class ExportSubjectsMapper
extends TableMapper<Text, Text> {
    private static final Log log = LogFactory.getLog(ExportSubjectsMapper.class);
    private static final String CF = "result";
    private Text keyOut;
    private Text one;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new Text("");
        this.one = new Text("1");
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            byte[] body = value.getValue(Bytes.toBytes((String)CF), DedupUtils.BODY_B);
            if (body == null) {
                context.getCounter(CF, "missing body").increment(1L);
                return;
            }
            OafProtos.Oaf d = OafDecoder.decode((byte[])body).getOaf();
            if (d.getDataInfo().getDeletedbyinference()) {
                context.getCounter(CF, "deleted by inference").increment(1L);
                return;
            }
            ResultProtos.Result.Metadata m = d.getEntity().getResult().getMetadata();
            if (m.getSubjectCount() > 0) {
                m.getSubjectList().stream().map(s -> new Subject(s.getQualifier().getClassid(), s.getValue())).forEach(s -> {
                    this.keyOut.set(s.toJson());
                    try {
                        context.write((Object)this.keyOut, (Object)this.one);
                    }
                    catch (IOException | InterruptedException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Throwable e) {
            log.error((Object)("error exporting the following record from HBase: " + value.toString()), e);
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }
}

