/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataexport;

import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.dataexport.Subject;
import eu.dnetlib.data.mapreduce.util.StreamUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class ExportSubjectsReducer
extends Reducer<Text, Text, Text, Text> {
    private static final Log log = LogFactory.getLog(ExportSubjectsReducer.class);
    private Text keyOut = new Text("");
    private Text valueOut = new Text("");

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
    }

    protected void reduce(Text keyIn, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        try {
            Subject s = (Subject)new Gson().fromJson((Reader)new StringReader(keyIn.toString()), Subject.class);
            long count = StreamUtils.toStream(values.iterator()).count();
            s.setCount(count);
            this.valueOut.set(s.toJson());
            context.write((Object)this.keyOut, (Object)this.valueOut);
        }
        catch (Throwable e) {
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }
}

