/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.hbase.dataimport.DumpToActionsUtility;
import eu.dnetlib.data.mapreduce.hbase.dataimport.ScholExplorerConfiguration;
import eu.dnetlib.data.mapreduce.util.StreamUtils;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ScholixToActions {
    public static List<AtomicAction> generateActionsFromScholix(JsonObject rootElement, Map<String, ScholExplorerConfiguration> conf, String setName, Agent agent, ActionFactory factory, String nsPrefix, String dsName, String dsId, String dateOfCollection) {
        ArrayList<AtomicAction> actions = new ArrayList<AtomicAction>();
        String typology = DumpToActionsUtility.getStringValue(rootElement, "typology");
        List<String> publisher = DumpToActionsUtility.getArrayValues(rootElement, "publisher");
        String abstractValue = DumpToActionsUtility.getStringValue(rootElement, "abstract");
        List<String> authors = DumpToActionsUtility.getArrayValues(rootElement, "author");
        List<String> dates = DumpToActionsUtility.getArrayValues(rootElement, "date");
        JsonArray localIdentifiers = rootElement.getAsJsonArray("localIdentifier");
        String dnetId = DumpToActionsUtility.getStringValue(rootElement, "id").substring(17);
        String title = "";
        if (rootElement.has("title") && rootElement.get("title").isJsonArray()) {
            StringBuilder ttl = new StringBuilder();
            DumpToActionsUtility.getArrayValues(rootElement, "title").forEach(ttl::append);
            title = ttl.toString();
        } else {
            title = DumpToActionsUtility.getStringValue(rootElement, "title");
        }
        if (title != null && title.charAt(0) == '\"' && title.charAt(title.length() - 1) == '\"') {
            title = title.substring(1, title.length() - 1);
        }
        OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
        boolean isVisible = StringUtils.isNotBlank((CharSequence)title) && StreamUtils.toStream(localIdentifiers.iterator()).map(JsonElement::getAsJsonObject).anyMatch(o -> {
            String type = DumpToActionsUtility.getStringValue(o, "type");
            return StringUtils.isNotBlank((CharSequence)type) && conf.containsKey(type) && ((ScholExplorerConfiguration)conf.get(type)).isVisible();
        });
        oafBuilder.setDataInfo(FieldTypeProtos.DataInfo.newBuilder().setInvisible(!isVisible).setDeletedbyinference(false).setInferred(false).setTrust("0.9").setProvenanceaction(DumpToActionsUtility.getQualifier("sysimport:actionset", "dnet:provenanceActions")).build());
        oafBuilder.setKind(KindProtos.Kind.entity);
        String sourceId = String.format("50|%s::%s", nsPrefix, dnetId);
        FieldTypeProtos.KeyValue collectedFrom = FieldTypeProtos.KeyValue.newBuilder().setValue(dsName).setKey("10|openaire____::" + AbstractDNetXsltFunctions.md5((String)dsId)).build();
        OafProtos.OafEntity.Builder oafEntityBuilder = OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result).setDateofcollection(dateOfCollection).addCollectedfrom(collectedFrom).setId(sourceId);
        StreamUtils.toStream(localIdentifiers.iterator()).map(JsonElement::getAsJsonObject).map(localIdentifier -> DumpToActionsUtility.getPid(localIdentifier, conf)).filter(Objects::nonNull).forEach(arg_0 -> ((OafProtos.OafEntity.Builder)oafEntityBuilder).addPid(arg_0));
        ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder();
        ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder().setResulttype(DumpToActionsUtility.getQualifier(typology, "dnet:result_typologies")).setLanguage(FieldTypeProtos.Qualifier.newBuilder().setClassid("und").setClassname("Undetermined").setSchemeid("dent:languages").setSchemename("dent:languages").build());
        if (StringUtils.isNotBlank((CharSequence)title)) {
            metadata.addTitle(FieldTypeProtos.StructuredProperty.newBuilder().setValue(title).setQualifier(DumpToActionsUtility.getQualifier("main title", "dnet:dataCite_title")).build());
        }
        if (publisher.size() > 0) {
            metadata.setPublisher(FieldTypeProtos.StringField.newBuilder().setValue(publisher.get(0)).build());
        }
        if (StringUtils.isNotEmpty((CharSequence)abstractValue)) {
            metadata.addDescription(FieldTypeProtos.StringField.newBuilder().setValue(abstractValue).build());
        }
        dates.stream().map(d -> {
            if (d.length() == 4 && StringUtils.isNumeric((CharSequence)d)) {
                return d + "-01-01";
            }
            return d;
        }).filter(d -> DumpToActionsUtility.isValidDate(d)).forEach(d -> metadata.addRelevantdate(FieldTypeProtos.StructuredProperty.newBuilder().setValue(d).setQualifier(DumpToActionsUtility.getQualifier("dnet:date", "dnet:date")).build()));
        if (rootElement.has("subject")) {
            JsonArray subject = rootElement.getAsJsonArray("subject");
            subject.forEach(it -> {
                JsonObject item = it.getAsJsonObject();
                String scheme = DumpToActionsUtility.getStringValue(item, "scheme");
                metadata.addSubject(FieldTypeProtos.StructuredProperty.newBuilder().setValue(Objects.requireNonNull(DumpToActionsUtility.getStringValue(item, "value"))).setQualifier(DumpToActionsUtility.getQualifier(scheme, "dnet:subject")).build());
            });
        }
        int i = 1;
        for (String it2 : authors) {
            metadata.addAuthor(FieldTypeProtos.Author.newBuilder().setFullname(it2).setRank(i++).build());
        }
        result.setMetadata(metadata.build());
        localIdentifiers.forEach(it -> {
            JsonObject localIdentifier = it.getAsJsonObject();
            String pidType = DumpToActionsUtility.getStringValue(localIdentifier, "type");
            ScholExplorerConfiguration currentConf = (ScholExplorerConfiguration)conf.get(pidType);
            if (currentConf.getGeneratedUrl() != null) {
                ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder();
                String pidValue = DumpToActionsUtility.getStringValue(localIdentifier, "id");
                instance.addUrl(String.format(currentConf.getGeneratedUrl(), pidValue));
                instance.setAccessright(FieldTypeProtos.Qualifier.newBuilder().setClassid("UNKNOWN").setClassname("not available").setSchemeid("dnet:access_modes").setSchemename("dnet:access_modes").build());
                instance.setInstancetype(FieldTypeProtos.Qualifier.newBuilder().setClassid("0000").setClassname("Unknown").setSchemeid("dnet:publication_resource").setSchemename("dnet:publication_resource").build());
                instance.setHostedby(FieldTypeProtos.KeyValue.newBuilder().setKey("10|openaire____::55045bd2a65019fd8e6741a755395c8c").setValue("Unknown Repository").build());
                instance.setCollectedfrom(collectedFrom);
                result.addInstance(instance);
            }
        });
        ScholixToActions.generateExternalReference(ScholixToActions.extractRelations(rootElement, "externalRels")).forEach(arg_0 -> ((ResultProtos.Result.Builder)result).addExternalReference(arg_0));
        oafEntityBuilder.setResult(result.build());
        oafBuilder.setEntity(oafEntityBuilder.build());
        actions.add(factory.createAtomicAction(setName, agent, oafEntityBuilder.getId(), "result", "body", oafBuilder.build().toByteArray()));
        List<JsonObject> doiRels = ScholixToActions.extractRelations(rootElement, "doiRels");
        doiRels.stream().map(it -> ScholixToActions.convertDoiRelations(it, factory, sourceId, nsPrefix, collectedFrom, setName, agent)).forEach(actions::addAll);
        return actions;
    }

    private static AtomicAction createResultResultRelation(String source, String target, FieldTypeProtos.KeyValue collectedFrom, ResultResultProtos.ResultResult resultResultRel, String relClass, String cfRelation, ActionFactory factory, String setName, Agent agent) {
        OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder();
        oaf.setDataInfo(FieldTypeProtos.DataInfo.newBuilder().setDeletedbyinference(false).setInferred(false).setTrust("0.9").setProvenanceaction(DumpToActionsUtility.getQualifier("sysimport:actionset", "dnet:provenanceActions")).build());
        oaf.setKind(KindProtos.Kind.relation);
        OafProtos.OafRel.Builder relation = OafProtos.OafRel.newBuilder();
        relation.setSource(source);
        relation.setTarget(target);
        relation.setRelType(RelTypeProtos.RelType.resultResult);
        if (StringUtils.contains((CharSequence)relClass.toLowerCase(), (CharSequence)"supplement")) {
            relation.setSubRelType(RelTypeProtos.SubRelType.supplement);
        } else {
            relation.setSubRelType(RelTypeProtos.SubRelType.publicationDataset);
        }
        relation.setChild(false);
        relation.setResultResult(resultResultRel);
        relation.setRelClass(relClass);
        relation.addCollectedfrom(collectedFrom);
        oaf.setRel(relation.build());
        return factory.createAtomicAction(setName, agent, source, cfRelation, target, oaf.build().toByteArray());
    }

    private static List<AtomicAction> convertDoiRelations(JsonObject doiRel, ActionFactory factory, String sourceId, String nsPrefix, FieldTypeProtos.KeyValue collectedFrom, String setName, Agent agent) {
        String inverseRelClass;
        String relClass;
        String cfInverseRelation;
        String cfRelation;
        String target = Objects.requireNonNull(DumpToActionsUtility.getStringValue(doiRel, "dnetId")).substring(17);
        String targetId = String.format("50|%s::%s", nsPrefix, target);
        String relationSemantic = DumpToActionsUtility.getStringValue(doiRel, "relationSemantic");
        ResultResultProtos.ResultResult.Builder resultRel = ResultResultProtos.ResultResult.newBuilder();
        ResultResultProtos.ResultResult.Builder resultInverseRel = ResultResultProtos.ResultResult.newBuilder();
        switch (relationSemantic) {
            case "isSupplementedBy": {
                cfRelation = "resultResult_supplement_isSupplementedBy";
                cfInverseRelation = "resultResult_supplement_isSupplementTo";
                relClass = ResultResultProtos.ResultResult.Supplement.RelName.isSupplementedBy.toString();
                inverseRelClass = ResultResultProtos.ResultResult.Supplement.RelName.isSupplementTo.toString();
                resultRel.setSupplement(ResultResultProtos.ResultResult.Supplement.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DumpToActionsUtility.getQualifier(relClass, "dnet:result_result_relations")).build()).build());
                resultInverseRel.setSupplement(ResultResultProtos.ResultResult.Supplement.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DumpToActionsUtility.getQualifier(inverseRelClass, "dnet:result_result_relations")).build()).build());
                break;
            }
            case "isSupplementTo": {
                cfRelation = "resultResult_supplement_isSupplementTo";
                cfInverseRelation = "resultResult_supplement_isSupplementedBy";
                inverseRelClass = ResultResultProtos.ResultResult.Supplement.RelName.isSupplementedBy.toString();
                relClass = ResultResultProtos.ResultResult.Supplement.RelName.isSupplementTo.toString();
                resultInverseRel.setSupplement(ResultResultProtos.ResultResult.Supplement.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DumpToActionsUtility.getQualifier(inverseRelClass, "dnet:result_result_relations")).build()).build());
                resultRel.setSupplement(ResultResultProtos.ResultResult.Supplement.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DumpToActionsUtility.getQualifier(relClass, "dnet:result_result_relations")).build()).build());
                break;
            }
            default: {
                cfRelation = "resultResult_publicationDataset_isRelatedTo";
                cfInverseRelation = "resultResult_publicationDataset_isRelatedTo";
                inverseRelClass = relClass = ResultResultProtos.ResultResult.PublicationDataset.RelName.isRelatedTo.toString();
                resultInverseRel.setPublicationDataset(ResultResultProtos.ResultResult.PublicationDataset.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DumpToActionsUtility.getQualifier(relClass, "dnet:result_result_relations")).build()).build());
                resultRel = resultInverseRel;
            }
        }
        ArrayList<AtomicAction> actions = new ArrayList<AtomicAction>();
        actions.add(ScholixToActions.createResultResultRelation(sourceId, targetId, collectedFrom, resultRel.build(), relClass, cfRelation, factory, setName, agent));
        actions.add(ScholixToActions.createResultResultRelation(targetId, sourceId, collectedFrom, resultInverseRel.build(), inverseRelClass, cfInverseRelation, factory, setName, agent));
        return actions;
    }

    private static List<ResultProtos.Result.ExternalReference> generateExternalReference(List<JsonObject> jsonRels) {
        ArrayList<ResultProtos.Result.ExternalReference> result = new ArrayList<ResultProtos.Result.ExternalReference>();
        jsonRels.forEach(it -> {
            ResultProtos.Result.ExternalReference.Builder builder = ResultProtos.Result.ExternalReference.newBuilder();
            if ("url".equals(DumpToActionsUtility.getStringValue(it.getAsJsonObject("id"), "schema"))) {
                builder.setUrl(Objects.requireNonNull(DumpToActionsUtility.getStringValue(it.getAsJsonObject("id"), "identifier")));
            }
            result.add(builder.setRefidentifier(Objects.requireNonNull(DumpToActionsUtility.getStringValue(it.getAsJsonObject("id"), "identifier"))).setSitename(Objects.requireNonNull(DumpToActionsUtility.getStringValue(it, "collectedFrom"))).setQualifier(FieldTypeProtos.Qualifier.newBuilder().setClassid(Objects.requireNonNull(DumpToActionsUtility.getStringValue(it.getAsJsonObject("id"), "schema"))).setClassname(Objects.requireNonNull(DumpToActionsUtility.getStringValue(it.getAsJsonObject("id"), "schema"))).setSchemename("dnet:externalReference_typologies").setSchemeid("dnet:externalReference_typologies").build()).build());
        });
        return result;
    }

    private static List<JsonObject> extractRelations(JsonObject rootElement, String fieldType) {
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        if (rootElement.has(fieldType) && rootElement.get(fieldType).isJsonArray()) {
            JsonArray asJsonArray = rootElement.getAsJsonArray(fieldType);
            asJsonArray.forEach(it -> result.add(it.getAsJsonObject()));
        }
        return result;
    }
}

