/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.hbase.dataimport.GridAcToActions;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class GridAcImportMapper
extends Mapper<LongWritable, Text, Text, Text> {
    private String setName;
    private Agent agent;
    private Text keyout;
    private Text valueOut;
    private ActionFactory factory;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.setName = context.getConfiguration().get("setName");
        this.agent = new Agent(context.getConfiguration().get("agentId"), context.getConfiguration().get("agentName"), Agent.AGENT_TYPE.service);
        this.keyout = new Text("");
        this.valueOut = new Text("");
        this.factory = new ActionFactory();
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String inputJson = value.toString();
        OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder();
        JsonFormat.merge((CharSequence)value.toString(), (Message.Builder)oaf);
        try {
            AtomicAction action = GridAcToActions.generateActionsFromDump(oaf.build(), this.factory, this.setName, this.agent);
            this.keyout.set(action.getRowKey());
            this.valueOut.set(action.toJSON());
            context.write((Object)this.keyout, (Object)this.valueOut);
        }
        catch (Throwable e) {
            System.err.println(inputJson);
            throw e;
        }
    }
}

