package eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

import java.io.IOException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class PubSfwLinkReducer extends Reducer<ImmutableBytesWritable, Text, Text,Text> {

    private static final Log log = LogFactory.getLog(PubSfwLinkReducer.class); // NOPMD by marko on 11/24/08 5:02 PM

    private Text keyOut;
    private Text outValue;

    @Override
    protected void setup(final Context context) throws IOException, InterruptedException {
        super.setup(context);
        keyOut = new Text("");
        outValue = new Text();
    }

    @Override
    protected void reduce(ImmutableBytesWritable key, Iterable<Text> values, Context context) throws IOException, InterruptedException {
        final ReturnedValues ret = ReturnedValues.newInstance();
        final Iterator<Text> it = values.iterator();

        while(it.hasNext()) {
            final Value value = Value.fromJson(it.next().toString());
            if(value != null) {
                switch (value.getType()) {

                    case publication:
                        ret.setPublicationPIDs(IdentifierList.fromJson(value.getValue()));
                        break;
                    case software:
                        ret.getLinkedSW().add(SoftwareResource.fromJson(value.getValue()));
                        break;
                }
            }
        }
        
       if(ret.getLinkedSW().size() > 0 && ret.getPublicationPIDs()!=null) {
            ret.setOpenAireId(Bytes.toString(key.copyBytes()));
            outValue.set(ret.toJson());

            context.write(keyOut, outValue);
            context.getCounter("Find Link Pub Software", "write new association").increment(1);
        }

    }

    private List<String> getURLs(List<SoftwareResource> list) {
        HashSet<String> a = list.stream()
                .map(s -> s.getUrls())
                .flatMap(Collection::stream)
                .collect(Collectors.toCollection(HashSet::new));

        return Lists.newArrayList(a);

    }

    private List<Identifier> getPids(List<SoftwareResource> list) {
        return Lists.newArrayList(list.stream()
                .map(s -> s.getSoftwarePIDs())
                .flatMap(Collection::stream)
                .collect(Collectors.toMap(
                        Identifier::getPid,
                        Function.identity(),
                        (id1, id2) -> id1
                )).values());
    }

    private String getId(List<SoftwareResource> list) {
        return list.get(0).getOpenAireId();
    }

}


