/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.bulktag;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import eu.dnetlib.data.bulktag.CommunityConfiguration;
import eu.dnetlib.data.bulktag.CommunityConfigurationFactory;
import eu.dnetlib.data.mapreduce.hbase.bulktag.Param;
import eu.dnetlib.data.mapreduce.hbase.bulktag.ResultTagger;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class BulkTaggingMapper
extends TableMapper<ImmutableBytesWritable, Writable> {
    private CommunityConfiguration cc;
    private ResultTagger tagger;
    private boolean enabled;
    private Map<String, String> params;
    private Param param;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String conf = context.getConfiguration().get("tagging.conf");
        this.enabled = context.getConfiguration().getBoolean("tagging.enabled", false);
        if (StringUtils.isBlank((String)conf)) {
            throw new IllegalArgumentException("missing bulk tagging configuration");
        }
        System.out.println("conf = " + conf);
        this.cc = CommunityConfigurationFactory.fromJson((String)conf);
        this.tagger = new ResultTagger();
        this.tagger.setTrust(context.getConfiguration().get("bulktagging.trust", "0.85"));
        this.param = (Param)new Gson().fromJson(context.getConfiguration().get("mapping.proto", "{}"), Param.class);
        this.params = this.param.getP();
    }

    private Map<String, String> loadMapping(String mapping) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)new Gson().fromJson(mapping, type);
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        NavigableMap resultMap = value.getFamilyMap(Bytes.toBytes((String)"result"));
        byte[] body = (byte[])resultMap.get(Bytes.toBytes((String)"body"));
        if (body != null) {
            context.getCounter("Bulk Tagging", "not null body ").increment(1L);
            OafProtos.Oaf oaf = this.tagger.enrichContextCriteria(body, this.cc, context, this.params);
            if (oaf == null) {
                return;
            }
            long tagged = oaf.getEntity().getResult().getMetadata().getContextList().stream().flatMap(c -> c.getDataInfoList().stream()).map(FieldTypeProtos.DataInfo::getInferenceprovenance).filter(infProv -> "bulktagging".equals(infProv)).count();
            context.getCounter("Bulk Tagging", " bulktagged ").increment(tagged);
            Put put = new Put(key.copyBytes()).add(Bytes.toBytes((String)"result"), Bytes.toBytes((String)"body"), oaf.toByteArray());
            if (this.enabled) {
                context.write((Object)key, (Object)put);
            }
            context.getCounter("Bulk Tagging", " write op ").increment(1L);
        } else {
            context.getCounter("Bulk Tagging", " null body ").increment(1L);
        }
    }

    private Map<String, List<String>> getParamMap(byte[] body) {
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        DocumentContext jsonContext = JsonPath.parse((Object)body);
        for (String key : this.params.keySet()) {
            try {
                param.put(key, (List<String>)jsonContext.read(this.params.get(key), new Predicate[0]));
            }
            catch (Exception e) {
                param.put(key, new ArrayList());
            }
        }
        return param;
    }
}

