/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import eu.dnetlib.data.mapreduce.hbase.dataimport.ScholExplorerConfiguration;
import eu.dnetlib.data.proto.FieldTypeProtos;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DumpToActionsUtility {
    public static String getStringValue(JsonObject root, String key) {
        if (root.has(key) && !root.get(key).isJsonNull()) {
            return root.get(key).getAsString();
        }
        return null;
    }

    public static List<String> getArrayValues(JsonObject root, String key) {
        if (root.has(key) && root.get(key).isJsonArray()) {
            JsonArray asJsonArray = root.get(key).getAsJsonArray();
            ArrayList<String> result = new ArrayList<String>();
            asJsonArray.forEach(it -> {
                if (StringUtils.isNotBlank((CharSequence)it.getAsString())) {
                    result.add(it.getAsString());
                }
            });
            return result;
        }
        return new ArrayList<String>();
    }

    public static List<JsonObject> getArrayObjects(JsonObject root, String key) {
        if (root.has(key) && root.get(key).isJsonArray()) {
            JsonArray asJsonArray = root.get(key).getAsJsonArray();
            ArrayList<JsonObject> result = new ArrayList<JsonObject>();
            asJsonArray.forEach(it -> {
                if (it.getAsJsonObject() != null) {
                    result.add(it.getAsJsonObject());
                }
            });
            return result;
        }
        return new ArrayList<JsonObject>();
    }

    public static boolean isValidDate(String date) {
        return date.matches("\\d{4}-\\d{2}-\\d{2}");
    }

    public static FieldTypeProtos.StructuredProperty getPid(JsonObject localIdentifier, Map<String, ScholExplorerConfiguration> conf) {
        String pidType = DumpToActionsUtility.getStringValue(localIdentifier, "type");
        ScholExplorerConfiguration configuration = conf.get(pidType);
        if (configuration.getCleandPidType() == null) {
            return null;
        }
        String pid = DumpToActionsUtility.getStringValue(localIdentifier, "id");
        return FieldTypeProtos.StructuredProperty.newBuilder().setValue(pid).setQualifier(DumpToActionsUtility.getQualifier(configuration.getCleandPidType(), "dnet:pid_types")).build();
    }

    public static FieldTypeProtos.Qualifier getQualifier(String classValue, String schemeValue) {
        return FieldTypeProtos.Qualifier.newBuilder().setSchemeid(schemeValue).setSchemename(schemeValue).setClassname(classValue).setClassid(classValue).build();
    }

    public static String getDefaultResulttype(String cobjcategory) {
        switch (cobjcategory) {
            case "0029": {
                return "software";
            }
            case "0021": 
            case "0024": 
            case "0025": 
            case "0030": {
                return "dataset";
            }
            case "0000": 
            case "0010": 
            case "0018": 
            case "0020": 
            case "0022": 
            case "0023": 
            case "0026": 
            case "0027": 
            case "0028": 
            case "0037": {
                return "other";
            }
            case "0001": 
            case "0002": 
            case "0004": 
            case "0005": 
            case "0006": 
            case "0007": 
            case "0008": 
            case "0009": 
            case "0011": 
            case "0012": 
            case "0013": 
            case "0014": 
            case "0015": 
            case "0016": 
            case "0017": 
            case "0019": 
            case "0031": 
            case "0032": {
                return "publication";
            }
        }
        return "publication";
    }
}

