package eu.dnetlib.data.mapreduce.hbase.propagation;

import com.google.common.collect.Sets;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;

import java.util.Set;

public class PropagationConstants {

    public enum Type {
        valid,
        notvalid,
        fromsemrel,
        fromresult;
    }

    public static final String ZERO = "0";
    public static final String ONE = "1";

    public static final int FROM_SEM_REL = 10;//for the relation to projects propagated thanks to a semantic relation
    public static final int FROM_RESULT = 20;//for the relations to projects already owned by the result

    public static final String COUNTER_PROPAGATION = "Propagation";


    public final static String DATA_INFO_TYPE = "propagation";
    public final static String SCHEMA_NAME = "dnet:provenanceActions";
    public final static String SCHEMA_ID = "dnet:provenanceActions";

    public final static String DNET_COUNTRY_SCHEMA = "dnet:countries";
    public final static String DNET_RELATION_SCHEMA = "dnet:result_project_relations";
    public final static String DNET_COMMUNITY_RELATION_SCHEMA = "dnet:result_result_relations";
    public final static String CLASS_RELATION_ID = "propagation:project:semrel";
    public final static String CLASS_COUNTRY_ID = "propagation:country:instrepos";
    public final static String CLASS_COMMUNITY_RELATION_ID = "propagation:community:semrel";

    public final static int PROJECT = TypeProtos.Type.project.getNumber();//40
    public final static int DATASOURCE = TypeProtos.Type.datasource.getNumber();//10
    public final static int ORGANIZATION = TypeProtos.Type.organization.getNumber();//20
    public final static int PUBLICATION = TypeProtos.Type.result.getNumber();//50

    public final static RelTypeProtos.RelType REL_TYPE = RelTypeProtos.RelType.resultProject;
    public final static RelTypeProtos.SubRelType SUBREL_TYPE = RelTypeProtos.SubRelType.outcome;
    public static final String REL_PROJECT_RESULT = "produces";
    public static final String REL_RESULT_PROJECT = "isProducedBy";

    public static final String RELATION = REL_TYPE + "_" + SUBREL_TYPE + "_";
    public static final String OUTCOME_PRODUCEDBY = RELATION + REL_RESULT_PROJECT;


    public static final String[] DEFAULT_PROJECT_RELATION_SET = new String[]{"resultResult_supplement_isSupplementedBy","resultResult_supplement_isSupplementTo"};
    public static final String[] DEFAULT_COMMUNITY_RELATION_SET = new String[]{"resultResult_supplement_isSupplementedBy","resultResult_supplement_isSupplementTo"};
    public static final Set<String> DEFAULT_ALLOWED_DATASOURCES = Sets.newHashSet("pubsrepository::institutional");

    private Set<String> whiteList = Sets.newHashSet("10|opendoar____::300891a62162b960cf02ce3827bb363c");
    private Set<String> blackList = Sets.newHashSet("");

}
